/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.store;

import com.avioconsulting.mule.opentelemetry.internal.processor.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.store.FlowSpan;
import com.avioconsulting.mule.opentelemetry.internal.store.ProcessorSpan;
import com.avioconsulting.mule.opentelemetry.internal.store.SpanMeta;
import com.avioconsulting.mule.opentelemetry.internal.store.Transaction;
import com.avioconsulting.mule.opentelemetry.internal.store.TransactionMeta;
import com.avioconsulting.mule.opentelemetry.internal.store.TransactionStore;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryTransactionStore
implements TransactionStore {
    private static TransactionStore service;
    private final ConcurrentHashMap<String, Transaction> transactionMap = new ConcurrentHashMap();
    private static final Logger LOGGER;

    public static synchronized TransactionStore getInstance() {
        if (service == null) {
            service = new InMemoryTransactionStore();
        }
        return service;
    }

    @Override
    public void startTransaction(TraceComponent traceComponent, String rootFlowName, SpanBuilder rootFlowSpanBuilder) {
        String transactionId = traceComponent.getTransactionId();
        Transaction transaction = this.getTransaction(traceComponent.getTransactionId());
        if (transaction != null) {
            LOGGER.trace("Start transaction {} for flow '{}' - Adding to existing transaction", (Object)transactionId, (Object)rootFlowName);
            transaction.getRootFlowSpan().addProcessorSpan(null, traceComponent, rootFlowSpanBuilder);
        } else {
            Span span = rootFlowSpanBuilder.startSpan();
            LOGGER.trace("Start transaction {} for flow '{}': OT SpanId {}, TraceId {}", new Object[]{transactionId, rootFlowName, span.getSpanContext().getSpanId(), span.getSpanContext().getTraceId()});
            this.transactionMap.put(transactionId, new Transaction(traceComponent.getTransactionId(), span.getSpanContext().getTraceId(), rootFlowName, new FlowSpan(rootFlowName, span, transactionId).setTags(traceComponent.getTags()), traceComponent.getStartTime()));
        }
    }

    @Override
    public void addTransactionTags(String transactionId, String tagPrefix, Map<String, String> tags) {
        AttributesBuilder builder = Attributes.builder();
        String format = "%s.%s";
        tags.forEach((k, v) -> builder.put(String.format(format, tagPrefix, k), v));
        Transaction transaction = this.getTransaction(transactionId);
        Span span = transaction.getRootFlowSpan().getSpan();
        if (span != null) {
            span.setAllAttributes(builder.build());
        }
    }

    private Transaction getTransaction(String transactionId) {
        return this.transactionMap.get(transactionId);
    }

    private Context getTransactionContext(Transaction transaction) {
        return transaction == null ? Context.current() : transaction.getRootFlowSpan().getSpan().storeInContext(Context.current());
    }

    @Override
    public Context getTransactionContext(String transactionId, ComponentLocation componentLocation) {
        Transaction transaction = this.getTransaction(transactionId);
        if (componentLocation == null) {
            return this.getTransactionContext(transaction);
        }
        ProcessorSpan processorSpan = null;
        if (transaction != null && (processorSpan = transaction.getRootFlowSpan().findSpan(componentLocation.getLocation())) != null) {
            return processorSpan.getSpan().storeInContext(Context.current());
        }
        return this.getTransactionContext(transaction);
    }

    @Override
    public String getTraceIdForTransaction(String transactionId) {
        return this.transactionMap.containsKey(transactionId) ? this.getTransaction(transactionId).getTraceId() : null;
    }

    @Override
    public TransactionMeta endTransaction(String transactionId, String flowName, Consumer<Span> spanUpdater, Instant endTime) {
        LOGGER.trace("End transaction {} for flow '{}'", (Object)transactionId, (Object)flowName);
        Consumer<Span> endSpan = span -> {
            if (spanUpdater != null) {
                spanUpdater.accept((Span)span);
            }
            span.end(endTime);
            LOGGER.trace("Ended transaction {} for flow '{}': OT SpanId {}, TraceId {}", new Object[]{transactionId, flowName, span.getSpanContext().getSpanId(), span.getSpanContext().getTraceId()});
        };
        Transaction transaction = this.getTransaction(transactionId);
        if (transaction != null) {
            if (transaction.getRootFlowName().equals(flowName)) {
                Transaction removed = this.transactionMap.remove(transactionId);
                endSpan.accept(removed.getRootFlowSpan().getSpan());
                removed.setEndTime(endTime);
            } else {
                ProcessorSpan processorSpan = transaction.getRootFlowSpan().findSpan(flowName);
                if (processorSpan != null) {
                    endSpan.accept(processorSpan.getSpan());
                    processorSpan.setEndTime(endTime);
                }
                return processorSpan;
            }
        }
        return transaction;
    }

    @Override
    public void addProcessorSpan(String containerName, TraceComponent traceComponent, SpanBuilder spanBuilder) {
        Transaction transaction = this.getTransaction(traceComponent.getTransactionId());
        if (transaction == null) {
            return;
        }
        LOGGER.trace("Adding Processor span to transaction {} for location '{}'", (Object)traceComponent.getTransactionId(), (Object)traceComponent.getLocation());
        SpanMeta span = transaction.getRootFlowSpan().addProcessorSpan(containerName, traceComponent, spanBuilder);
        LOGGER.trace("Adding Processor span to transaction {} for locator span '{}': OT SpanId {}, TraceId {}", new Object[]{traceComponent.getTransactionId(), traceComponent.getLocation(), span.getSpanId(), span.getTraceId()});
    }

    @Override
    public SpanMeta endProcessorSpan(String transactionId, String location, Consumer<ProcessorSpan> spanUpdater, Instant endTime) {
        LOGGER.trace("Ending Processor span of transaction {} for location '{}'", (Object)transactionId, (Object)location);
        Transaction transaction = this.getTransaction(transactionId);
        if (transaction == null) {
            return null;
        }
        return transaction.getRootFlowSpan().endProcessorSpan(location, spanUpdater, endTime);
    }

    static {
        LOGGER = LoggerFactory.getLogger(InMemoryTransactionStore.class);
    }
}

