/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.config;

import com.avioconsulting.mule.opentelemetry.api.config.ExporterConfiguration;
import com.avioconsulting.mule.opentelemetry.api.config.OpenTelemetryResource;
import com.avioconsulting.mule.opentelemetry.api.config.SpanProcessorConfiguration;
import com.avioconsulting.mule.opentelemetry.api.config.TraceLevelConfiguration;
import com.avioconsulting.mule.opentelemetry.api.config.metrics.CustomMetricInstrumentDefinition;
import com.avioconsulting.mule.opentelemetry.internal.config.OpenTelemetryConfigWrapper;
import com.avioconsulting.mule.opentelemetry.internal.config.OpenTelemetryConfiguration;
import com.avioconsulting.mule.opentelemetry.internal.connection.OpenTelemetryConnection;
import com.avioconsulting.mule.opentelemetry.internal.connection.OpenTelemetryConnectionProvider;
import com.avioconsulting.mule.opentelemetry.internal.notifications.listeners.MetricEventNotificationListener;
import com.avioconsulting.mule.opentelemetry.internal.notifications.listeners.MuleMessageProcessorNotificationListener;
import com.avioconsulting.mule.opentelemetry.internal.notifications.listeners.MulePipelineMessageNotificationListener;
import com.avioconsulting.mule.opentelemetry.internal.operations.OpenTelemetryOperations;
import com.avioconsulting.mule.opentelemetry.internal.processor.MuleNotificationProcessor;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operations(value={OpenTelemetryOperations.class})
@ConnectionProviders(value={OpenTelemetryConnectionProvider.class})
@Configuration
public class OpenTelemetryExtensionConfiguration
implements Startable,
Stoppable,
OpenTelemetryConfiguration {
    public static final String PROP_MULE_OTEL_TRACING_DISABLED = "mule.otel.tracing.disabled";
    public static final String PROP_MULE_OTEL_METRICS_DISABLED = "mule.otel.metrics.disabled";
    private final Logger logger = LoggerFactory.getLogger(OpenTelemetryExtensionConfiguration.class);
    @RefName
    private String configName;
    @Parameter
    @Optional(defaultValue="false")
    @Summary(value="Turn off tracing for this application.")
    private boolean turnOffTracing;
    @Parameter
    @Optional(defaultValue="false")
    @Summary(value="Turn off Metrics for this application.")
    private boolean turnOffMetrics;
    @ParameterGroup(name="Resource")
    @Placement(order=10)
    @Summary(value="Open Telemetry Resource Configuration. System or Environment Variables will override this configuration.")
    private OpenTelemetryResource resource;
    @ParameterGroup(name="Exporter")
    @Placement(order=20)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private ExporterConfiguration exporterConfiguration;
    @ParameterGroup(name="Trace Levels")
    @Placement(order=30)
    private TraceLevelConfiguration traceLevelConfiguration;
    @ParameterGroup(name="Span Processor")
    @Placement(order=40, tab="Tracer Settings")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private SpanProcessorConfiguration spanProcessorConfiguration;
    @Parameter
    @Optional
    @NullSafe
    @Placement(order=501, tab="Metrics")
    @DisplayName(value="Custom Metric Instruments")
    @Summary(value="List of instruments for capturing custom metrics")
    private List<CustomMetricInstrumentDefinition> customMetricInstruments;
    private Map<String, CustomMetricInstrumentDefinition> metricInstrumentDefinitionMap;
    @Inject
    NotificationListenerRegistry notificationListenerRegistry;
    @Inject
    MuleNotificationProcessor muleNotificationProcessor;

    public List<CustomMetricInstrumentDefinition> getCustomMetricInstruments() {
        return this.customMetricInstruments;
    }

    @Override
    public Map<String, CustomMetricInstrumentDefinition> getMetricInstrumentDefinitionMap() {
        if (this.metricInstrumentDefinitionMap == null) {
            boolean usesReservedKeyWords = this.getCustomMetricInstruments().stream().map(CustomMetricInstrumentDefinition::getMetricName).anyMatch(name -> name.startsWith("otel."));
            if (usesReservedKeyWords) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Instrument names cannot use reserved namespaces - otel.*"));
            }
            this.metricInstrumentDefinitionMap = this.getCustomMetricInstruments().stream().collect(Collectors.toMap(CustomMetricInstrumentDefinition::getMetricName, Function.identity()));
        }
        return this.metricInstrumentDefinitionMap;
    }

    @Override
    public boolean isTurnOffTracing() {
        return System.getProperties().containsKey(PROP_MULE_OTEL_TRACING_DISABLED) ? Boolean.parseBoolean(System.getProperty(PROP_MULE_OTEL_TRACING_DISABLED)) : this.turnOffTracing;
    }

    @Override
    public boolean isTurnOffMetrics() {
        return System.getProperties().containsKey(PROP_MULE_OTEL_METRICS_DISABLED) ? Boolean.parseBoolean(System.getProperty(PROP_MULE_OTEL_METRICS_DISABLED)) : this.turnOffMetrics;
    }

    public OpenTelemetryExtensionConfiguration setTurnOffTracing(boolean turnOffTracing) {
        this.turnOffTracing = turnOffTracing;
        return this;
    }

    public OpenTelemetryExtensionConfiguration setTurnOffMetrics(boolean turnOffMetrics) {
        this.turnOffMetrics = turnOffMetrics;
        return this;
    }

    @Override
    public OpenTelemetryResource getResource() {
        return this.resource;
    }

    public OpenTelemetryExtensionConfiguration setResource(OpenTelemetryResource resource) {
        this.resource = resource;
        return this;
    }

    @Override
    public ExporterConfiguration getExporterConfiguration() {
        return this.exporterConfiguration;
    }

    public OpenTelemetryExtensionConfiguration setExporterConfiguration(ExporterConfiguration exporterConfiguration) {
        this.exporterConfiguration = exporterConfiguration;
        return this;
    }

    @Override
    public TraceLevelConfiguration getTraceLevelConfiguration() {
        return this.traceLevelConfiguration;
    }

    public OpenTelemetryExtensionConfiguration setTraceLevelConfiguration(TraceLevelConfiguration traceLevelConfiguration) {
        this.traceLevelConfiguration = traceLevelConfiguration;
        return this;
    }

    @Override
    public SpanProcessorConfiguration getSpanProcessorConfiguration() {
        return this.spanProcessorConfiguration;
    }

    public OpenTelemetryExtensionConfiguration setSpanProcessorConfiguration(SpanProcessorConfiguration spanProcessorConfiguration) {
        this.spanProcessorConfiguration = spanProcessorConfiguration;
        return this;
    }

    public OpenTelemetryExtensionConfiguration setCustomMetricInstruments(List<CustomMetricInstrumentDefinition> customMetricInstruments) {
        this.customMetricInstruments = customMetricInstruments;
        return this;
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    public void start() throws MuleException {
        if (this.disableTelemetry()) {
            this.logger.warn("Tracing and Metrics is disabled. OpenTelemetry will be turned off for config '{}'.", (Object)this.getConfigName());
            return;
        }
        this.logger.info("Initiating otel config - '{}'", (Object)this.getConfigName());
        this.muleNotificationProcessor.init(OpenTelemetryConnection.getInstance(new OpenTelemetryConfigWrapper(this)), this.getTraceLevelConfiguration());
        this.notificationListenerRegistry.registerListener((NotificationListener)new MuleMessageProcessorNotificationListener(this.muleNotificationProcessor));
        this.notificationListenerRegistry.registerListener((NotificationListener)new MulePipelineMessageNotificationListener(this.muleNotificationProcessor));
        this.notificationListenerRegistry.registerListener((NotificationListener)new MetricEventNotificationListener(this.muleNotificationProcessor), ext -> ext.getAction().getNamespace().equals("OPENTELEMETRY"));
    }

    private boolean disableTelemetry() {
        return this.isTurnOffTracing() && this.isTurnOffMetrics();
    }

    public void stop() throws MuleException {
        if (this.isTurnOffTracing()) {
            this.logger.info("{} is set to true. Configuration '{}' has been stopped.", (Object)PROP_MULE_OTEL_TRACING_DISABLED, (Object)this.getConfigName());
        }
    }
}

