/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.opentelemetry.metrics;

import com.avioconsulting.mule.opentelemetry.internal.connection.OpenTelemetryConnection;
import io.opentelemetry.instrumentation.runtimemetrics.java8.BufferPools;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Classes;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Cpu;
import io.opentelemetry.instrumentation.runtimemetrics.java8.GarbageCollector;
import io.opentelemetry.instrumentation.runtimemetrics.java8.MemoryPools;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Threads;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.JmxRuntimeMetricsUtil;
import java.util.ArrayList;
import java.util.List;

public class Java8RuntimeMetrics {
    public static void installMetrics(OpenTelemetryConnection openTelemetryConnection) {
        if (Double.parseDouble(System.getProperty("java.specification.version")) >= 17.0) {
            return;
        }
        ArrayList<AutoCloseable> observables = new ArrayList<AutoCloseable>();
        observables.addAll(openTelemetryConnection.registerMetricsObserver(BufferPools::registerObservers));
        observables.addAll(openTelemetryConnection.registerMetricsObserver(Classes::registerObservers));
        observables.addAll(openTelemetryConnection.registerMetricsObserver(Cpu::registerObservers));
        observables.addAll(openTelemetryConnection.registerMetricsObserver(GarbageCollector::registerObservers));
        observables.addAll(openTelemetryConnection.registerMetricsObserver(MemoryPools::registerObservers));
        observables.addAll(openTelemetryConnection.registerMetricsObserver(Threads::registerObservers));
        Thread cleanupTelemetry = new Thread(() -> JmxRuntimeMetricsUtil.closeObservers((List)observables));
        Runtime.getRuntime().addShutdownHook(cleanupTelemetry);
    }
}

