/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.operations;

import com.avioconsulting.mule.opentelemetry.api.config.metrics.CustomMetricInstrumentDefinition;
import com.avioconsulting.mule.opentelemetry.api.config.metrics.MetricAttribute;
import com.avioconsulting.mule.opentelemetry.internal.config.OpenTelemetryExtensionConfiguration;
import com.avioconsulting.mule.opentelemetry.internal.connection.OpenTelemetryConnection;
import com.avioconsulting.mule.opentelemetry.internal.notifications.MetricEventNotification;
import com.avioconsulting.mule.opentelemetry.internal.notifications.MetricNotificationAction;
import com.avioconsulting.mule.opentelemetry.internal.notifications.MetricNotificationActionProvider;
import com.avioconsulting.mule.opentelemetry.internal.operations.CustomMetricNameValueProvider;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.notification.Fires;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.extension.api.notification.NotificationActionDefinition;
import org.mule.runtime.extension.api.notification.NotificationEmitter;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;

public class OpenTelemetryOperations {
    @DisplayName(value="Get Trace Context")
    @Alias(value="get-trace-context")
    public Map<String, String> getTraceContext(@Connection Supplier<OpenTelemetryConnection> openTelemetryConnection, CorrelationInfo correlationInfo) {
        String transactionId = correlationInfo.getCorrelationId();
        return openTelemetryConnection.get().getTraceContext(transactionId);
    }

    @DisplayName(value="Add Custom Tags")
    public void addCustomTags(@Connection Supplier<OpenTelemetryConnection> openTelemetryConnection, Map<String, String> tags, CorrelationInfo correlationInfo) {
        openTelemetryConnection.get().getTransactionStore().addTransactionTags(correlationInfo.getCorrelationId(), "custom", tags);
    }

    @Fires(value={MetricNotificationActionProvider.class})
    @DisplayName(value="Add Custom Metric")
    @Alias(value="add-custom-metric")
    public void addCustomMetric(NotificationEmitter notificationEmitter, @Config OpenTelemetryExtensionConfiguration extensionConfiguration, @Placement(order=1) @OfValues(value=CustomMetricNameValueProvider.class, open=false) String metricName, @Placement(order=2) long value, @Placement(order=3) List<MetricAttribute> metricAttributes) {
        Set unknownKeys;
        CustomMetricInstrumentDefinition instrumentDefinition = extensionConfiguration.getMetricInstrumentDefinitionMap().get(metricName);
        if (instrumentDefinition == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Metric instrument details for '%s' not found on the configuration '%s'", (Object[])new Object[]{metricName, extensionConfiguration.getConfigName()}));
        }
        if (metricAttributes != null && !metricAttributes.isEmpty() && !(unknownKeys = metricAttributes.stream().map(MetricAttribute::getKey).filter(key -> !instrumentDefinition.getAttributeKeys().contains(key)).collect(Collectors.toSet())).isEmpty()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Attributes '%s' are not configured for metric '%s' on the configuration '%s'", (Object[])new Object[]{unknownKeys.toString(), metricName, extensionConfiguration.getConfigName()}));
        }
        MetricEventNotification<Long> longCounter = new MetricEventNotification().setMetricsInstrumentType(instrumentDefinition.getInstrumentType()).setMetricName(metricName).setMetricValue(value).setAttributes(metricAttributes);
        notificationEmitter.fire((NotificationActionDefinition)MetricNotificationAction.CUSTOM_METRIC, TypedValue.of(longCounter));
    }
}

