/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import com.avioconsulting.mule.opentelemetry.internal.processor.AbstractProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.ComponentWrapper;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.semconv.SemanticAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.metadata.TypedValue;

public class DBProcessorComponent
extends AbstractProcessorComponent {
    public static final String NAMESPACE = "db";

    @Override
    public boolean canHandle(ComponentIdentifier componentIdentifier) {
        return this.getNamespace().equalsIgnoreCase(componentIdentifier.getNamespace()) && this.getOperations().contains(componentIdentifier.getName().toLowerCase());
    }

    @Override
    protected String getNamespace() {
        return NAMESPACE;
    }

    @Override
    protected List<String> getOperations() {
        return Arrays.asList("select", "update", "insert", "delete", "bulk-update", "bulk-insert", "bulk-delete", "stored-procedure");
    }

    @Override
    protected List<String> getSources() {
        return Collections.emptyList();
    }

    @Override
    protected SpanKind getSpanKind() {
        return SpanKind.CLIENT;
    }

    @Override
    protected <A> Map<String, String> getAttributes(Component component, TypedValue<A> attributes) {
        ComponentWrapper componentWrapper = new ComponentWrapper(component, this.configurationComponentLocator);
        Map<String, String> connectionParams = componentWrapper.getConfigConnectionParameters();
        HashMap<String, String> tags = new HashMap<String, String>();
        String connectionComponentName = connectionParams.get("component:name");
        String connectionName = "other_sql";
        if (connectionComponentName != null) {
            connectionName = connectionComponentName.substring(0, connectionComponentName.lastIndexOf("-"));
            if ("generic".equalsIgnoreCase(connectionName) || "data-source".equalsIgnoreCase(connectionName)) {
                connectionName = "other_sql";
            } else if (connectionName.contains("-")) {
                connectionName = connectionName.replace("-", "");
            }
        }
        tags.put(SemanticAttributes.DB_SYSTEM.getKey(), connectionName);
        this.addTagIfPresent(connectionParams, "host", tags, SemanticAttributes.NET_PEER_NAME.getKey());
        this.addTagIfPresent(connectionParams, "port", tags, SemanticAttributes.NET_PEER_PORT.getKey());
        this.addTagIfPresent(connectionParams, "user", tags, SemanticAttributes.DB_USER.getKey());
        tags.put(SemanticAttributes.DB_STATEMENT.getKey(), componentWrapper.getParameter("sql"));
        tags.put(SemanticAttributes.DB_OPERATION.getKey(), component.getIdentifier().getName());
        this.addTagIfPresent(connectionParams, "dataSourceRef", tags, com.avioconsulting.mule.opentelemetry.internal.opentelemetry.sdk.SemanticAttributes.DB_DATASOURCE.getKey());
        this.addTagIfPresent(connectionParams, "databaseName", tags, SemanticAttributes.DB_NAME.getKey());
        this.addTagIfPresent(connectionParams, "database", tags, SemanticAttributes.DB_NAME.getKey());
        this.addTagIfPresent(connectionParams, "instanceName", tags, SemanticAttributes.DB_MSSQL_INSTANCE_NAME.getKey());
        this.addTagIfPresent(connectionParams, "instance", tags, "db.oracle.instance");
        this.addTagIfPresent(connectionParams, "serviceName", tags, "db.oracle.serviceName");
        tags.put(SemanticAttributes.DB_JDBC_DRIVER_CLASSNAME.getKey(), connectionParams.get("driverClassName"));
        return tags;
    }
}

