/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import com.avioconsulting.mule.opentelemetry.api.config.TraceLevelConfiguration;
import com.avioconsulting.mule.opentelemetry.api.processor.ProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.connection.OpenTelemetryConnection;
import com.avioconsulting.mule.opentelemetry.internal.notifications.MetricEventNotification;
import com.avioconsulting.mule.opentelemetry.internal.opentelemetry.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.internal.processor.FlowProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.GenericProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.metrics.DefaultMuleMetricsProcessor;
import com.avioconsulting.mule.opentelemetry.internal.processor.metrics.MuleMetricsProcessor;
import com.avioconsulting.mule.opentelemetry.internal.processor.service.ProcessorComponentService;
import com.avioconsulting.mule.opentelemetry.internal.store.SpanMeta;
import com.avioconsulting.mule.opentelemetry.internal.store.TransactionMeta;
import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import io.opentelemetry.api.trace.SpanKind;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.notification.ExtensionNotification;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleNotificationProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MuleNotificationProcessor.class);
    public static final String MULE_OTEL_SPAN_PROCESSORS_ENABLE_PROPERTY_NAME = "mule.otel.span.processors.enable";
    private Supplier<OpenTelemetryConnection> connectionSupplier;
    private boolean spanAllProcessors;
    private TraceLevelConfiguration traceLevelConfiguration;
    private OpenTelemetryConnection openTelemetryConnection;
    ConfigurationComponentLocator configurationComponentLocator;
    private final List<String> interceptSpannedComponents = new ArrayList<String>();
    private final List<String> meteredComponentLocations = new ArrayList<String>();
    private ProcessorComponentService processorComponentService;
    private final ProcessorComponent flowProcessorComponent;
    private final ProcessorComponent genericProcessorComponent;
    private MuleMetricsProcessor muleMetricsProcessor;

    @Inject
    public MuleNotificationProcessor(ConfigurationComponentLocator configurationComponentLocator) {
        this.configurationComponentLocator = configurationComponentLocator;
        this.flowProcessorComponent = new FlowProcessorComponent().withConfigurationComponentLocator(configurationComponentLocator);
        this.genericProcessorComponent = new GenericProcessorComponent().withConfigurationComponentLocator(configurationComponentLocator);
    }

    public void addInterceptSpannedComponents(String location) {
        this.interceptSpannedComponents.add(location);
    }

    public void addMeteredComponentLocation(String location) {
        this.meteredComponentLocations.add(location);
    }

    public boolean hasConnection() {
        return this.openTelemetryConnection != null;
    }

    public OpenTelemetryConnection getOpenTelemetryConnection() {
        return this.openTelemetryConnection;
    }

    public Supplier<OpenTelemetryConnection> getConnectionSupplier() {
        return this.connectionSupplier;
    }

    public TraceLevelConfiguration getTraceLevelConfiguration() {
        return this.traceLevelConfiguration;
    }

    public void init(OpenTelemetryConnection connection, TraceLevelConfiguration traceLevelConfiguration) {
        this.openTelemetryConnection = connection;
        this.spanAllProcessors = Boolean.parseBoolean(System.getProperty(MULE_OTEL_SPAN_PROCESSORS_ENABLE_PROPERTY_NAME, Boolean.toString(traceLevelConfiguration.isSpanAllProcessors())));
        this.traceLevelConfiguration = traceLevelConfiguration;
        this.processorComponentService = ProcessorComponentService.getInstance();
        this.muleMetricsProcessor = this.openTelemetryConnection == null || this.openTelemetryConnection.isTurnOffMetrics() ? MuleMetricsProcessor.noop : new DefaultMuleMetricsProcessor(this.openTelemetryConnection, this.meteredComponentLocations);
    }

    public void handleProcessorStartEvent(MessageProcessorNotification notification) {
        String location = notification.getComponent().getLocation().getLocation();
        if (this.interceptSpannedComponents.contains(location)) {
            logger.trace("Component {} will be processed by interceptor, skipping notification processing to create span", (Object)location);
            return;
        }
        try {
            ProcessorComponent processorComponent = this.getProcessorComponent(notification);
            if (processorComponent != null) {
                logger.trace("Handling '{}:{}' processor start event", (Object)notification.getResourceIdentifier(), (Object)notification.getComponent().getIdentifier());
                TraceComponent traceComponent = processorComponent.getStartTraceComponent((EnrichedServerNotification)notification).withStartTime(Instant.ofEpochMilli(notification.getTimestamp()));
                this.openTelemetryConnection.addProcessorSpan(traceComponent, notification.getComponent().getLocation().getRootContainerName());
            }
        }
        catch (Exception ex) {
            logger.error("Error in handling processor start event", (Throwable)ex);
            throw ex;
        }
    }

    ProcessorComponent getProcessorComponent(MessageProcessorNotification notification) {
        ComponentIdentifier identifier = notification.getComponent().getIdentifier();
        return this.getProcessorComponent(identifier);
    }

    public ProcessorComponent getProcessorComponent(ComponentIdentifier identifier) {
        boolean ignored = this.traceLevelConfiguration.getIgnoreMuleComponents().stream().anyMatch(mc -> mc.getNamespace().equalsIgnoreCase(identifier.getNamespace()) & (mc.getName().equalsIgnoreCase(identifier.getName()) || "*".equalsIgnoreCase(mc.getName())));
        if (this.spanAllProcessors && ignored) {
            return null;
        }
        ProcessorComponent processorComponent = this.processorComponentService.getProcessorComponentFor(identifier, this.configurationComponentLocator);
        if (processorComponent == null && this.spanAllProcessors) {
            processorComponent = this.genericProcessorComponent;
        }
        return processorComponent;
    }

    public void handleProcessorEndEvent(MessageProcessorNotification notification) {
        String location = notification.getComponent().getLocation().getLocation();
        try {
            ProcessorComponent processorComponent = this.getProcessorComponent(notification);
            if (processorComponent != null) {
                logger.trace("Handling '{}:{}' processor end event ", (Object)notification.getResourceIdentifier(), (Object)notification.getComponent().getIdentifier());
                TraceComponent traceComponent = processorComponent.getEndTraceComponent((EnrichedServerNotification)notification).withEndTime(Instant.ofEpochMilli(notification.getTimestamp()));
                SpanMeta spanMeta = this.openTelemetryConnection.endProcessorSpan(traceComponent, notification.getEvent().getError().orElse(null));
                if (ComponentsUtil.isFlowRef(notification.getComponent().getLocation())) {
                    ComponentsUtil.findLocation(traceComponent.getTags().get("mule.app.processor.flowRef.name"), this.configurationComponentLocator).filter(ComponentsUtil::isSubFlow).ifPresent(subFlowComp -> {
                        TraceComponent subflowTrace = TraceComponent.named(subFlowComp.getLocation()).withTransactionId(traceComponent.getTransactionId()).withLocation(subFlowComp.getLocation()).withSpanName(subFlowComp.getLocation()).withSpanKind(SpanKind.INTERNAL).withTags(Collections.singletonMap(SemanticAttributes.MULE_APP_SCOPE_SUBFLOW_NAME.getKey(), subFlowComp.getLocation())).withStatsCode(traceComponent.getStatusCode()).withEndTime(traceComponent.getEndTime()).withContext(traceComponent.getContext());
                        SpanMeta subFlow = this.openTelemetryConnection.endProcessorSpan(subflowTrace, notification.getEvent().getError().orElse(null));
                        if (subFlow != null) {
                            this.muleMetricsProcessor.captureProcessorMetrics(notification.getComponent(), notification.getEvent().getError().orElse(null), location, spanMeta);
                        }
                    });
                }
                if (spanMeta != null) {
                    this.muleMetricsProcessor.captureProcessorMetrics(notification.getComponent(), notification.getEvent().getError().orElse(null), location, spanMeta);
                }
            }
        }
        catch (Exception ex) {
            logger.error("Error in handling processor end event", (Throwable)ex);
            throw ex;
        }
    }

    public void handleFlowStartEvent(PipelineMessageNotification notification) {
        try {
            logger.trace("Handling '{}' flow start event", (Object)notification.getResourceIdentifier());
            TraceComponent traceComponent = this.flowProcessorComponent.getSourceStartTraceComponent((EnrichedServerNotification)notification, this.openTelemetryConnection).withStartTime(Instant.ofEpochMilli(notification.getTimestamp()));
            this.openTelemetryConnection.startTransaction(traceComponent);
        }
        catch (Exception ex) {
            logger.error("Error in handling " + notification.getResourceIdentifier() + " flow start event", (Throwable)ex);
            throw ex;
        }
    }

    public void handleFlowEndEvent(PipelineMessageNotification notification) {
        try {
            logger.trace("Handling '{}' flow end event", (Object)notification.getResourceIdentifier());
            TraceComponent traceComponent = this.flowProcessorComponent.getSourceEndTraceComponent((EnrichedServerNotification)notification, this.openTelemetryConnection).withEndTime(Instant.ofEpochMilli(notification.getTimestamp()));
            TransactionMeta transactionMeta = this.openTelemetryConnection.endTransaction(traceComponent, notification.getException());
            this.muleMetricsProcessor.captureFlowMetrics(transactionMeta, notification.getResourceIdentifier(), notification.getException());
        }
        catch (Exception ex) {
            logger.error("Error in handling " + notification.getResourceIdentifier() + " flow end event", (Throwable)ex);
            throw ex;
        }
    }

    public void captureCustomMetric(ExtensionNotification extensionNotification) {
        MetricEventNotification metric = (MetricEventNotification)extensionNotification.getData().getValue();
        this.muleMetricsProcessor.captureCustomMetric(metric);
    }
}

