/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor.metrics;

import com.avioconsulting.mule.opentelemetry.api.config.metrics.MetricsInstrumentType;
import com.avioconsulting.mule.opentelemetry.internal.config.CustomMetricInstrumentHolder;
import com.avioconsulting.mule.opentelemetry.internal.connection.OpenTelemetryConnection;
import com.avioconsulting.mule.opentelemetry.internal.notifications.MetricEventNotification;
import com.avioconsulting.mule.opentelemetry.internal.opentelemetry.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.internal.processor.metrics.MuleMetricsProcessor;
import com.avioconsulting.mule.opentelemetry.internal.store.SpanMeta;
import com.avioconsulting.mule.opentelemetry.internal.store.TransactionMeta;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongCounter;
import java.util.List;
import java.util.Objects;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.message.Error;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMuleMetricsProcessor
implements MuleMetricsProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMuleMetricsProcessor.class);
    public static final String UNIT_OF_ONE = "1";
    private final OpenTelemetryConnection openTelemetryConnection;
    private LongCounter muleMessageCounter;
    private DoubleHistogram muleMessageDurationHistogram;
    private LongCounter processorRequestCounter;
    private DoubleHistogram processorRequestDurationHistogram;
    private final List<String> meteredComponentLocations;

    public DefaultMuleMetricsProcessor(OpenTelemetryConnection openTelemetryConnection, List<String> meteredComponentLocations) {
        this.openTelemetryConnection = openTelemetryConnection;
        this.meteredComponentLocations = meteredComponentLocations;
        this.setupBasicMetrics();
    }

    private void setupBasicMetrics() {
        if (this.muleMessageCounter == null) {
            this.muleMessageCounter = this.openTelemetryConnection.createCounter("mule.app.message.count", "Number of Mule Messages triggered from Flow Invocations in the Mule Application", UNIT_OF_ONE);
        }
        if (this.muleMessageDurationHistogram == null) {
            this.muleMessageDurationHistogram = this.openTelemetryConnection.createHistogram("mule.app.message.duration", "Duration of Mule Messages");
        }
        if (this.processorRequestCounter == null) {
            this.processorRequestCounter = this.openTelemetryConnection.createCounter("mule.app.processor.request.count", "Number of requests processed by a processor during message processing in the Mule Application", UNIT_OF_ONE);
        }
        if (this.processorRequestDurationHistogram == null) {
            this.processorRequestDurationHistogram = this.openTelemetryConnection.createHistogram("mule.app.processor.request.duration", "Duration of Processor execution");
        }
    }

    @Override
    public void captureProcessorMetrics(Component component, Error error, String location, SpanMeta spanMeta) {
        if (this.meteredComponentLocations.contains(location)) {
            AttributesBuilder attributesBuilder = Attributes.builder().put(SemanticAttributes.MULE_APP_PROCESSOR_NAMESPACE, (Object)component.getIdentifier().getNamespace()).put(SemanticAttributes.MULE_APP_PROCESSOR_NAME, (Object)component.getIdentifier().getName());
            if (error != null) {
                attributesBuilder.put(SemanticAttributes.ERROR_TYPE, (Object)error.getErrorType().getIdentifier());
            }
            String value = null;
            value = spanMeta.getTags().get(SemanticAttributes.MULE_APP_PROCESSOR_CONFIG_REF.getKey());
            if (value != null) {
                attributesBuilder.put(SemanticAttributes.MULE_APP_PROCESSOR_CONFIG_REF, (Object)value);
            }
            Attributes attributes = attributesBuilder.build();
            this.processorRequestCounter.add(1L, attributes, spanMeta.getContext());
            this.processorRequestDurationHistogram.record((double)(spanMeta.getEndTime().toEpochMilli() - spanMeta.getStartTime().toEpochMilli()), attributes, spanMeta.getContext());
        }
    }

    @Override
    public void captureFlowMetrics(TransactionMeta transactionMeta, String flowName, Exception exception) {
        AttributesBuilder attributesBuilder = Attributes.builder().put(SemanticAttributes.MULE_APP_FLOW_NAME, (Object)flowName);
        if (exception != null) {
            attributesBuilder.put(SemanticAttributes.ERROR_TYPE, (Object)exception.getClass().getName());
        }
        String value = null;
        value = transactionMeta.getTags().get(SemanticAttributes.MULE_APP_FLOW_SOURCE_NAMESPACE.getKey());
        if (value != null) {
            attributesBuilder.put(SemanticAttributes.MULE_APP_FLOW_SOURCE_NAMESPACE, (Object)value);
        }
        if ((value = transactionMeta.getTags().get(SemanticAttributes.MULE_APP_FLOW_SOURCE_NAME.getKey())) != null) {
            attributesBuilder.put(SemanticAttributes.MULE_APP_FLOW_SOURCE_NAME, (Object)value);
        }
        if ((value = transactionMeta.getTags().get(SemanticAttributes.MULE_APP_FLOW_SOURCE_CONFIG_REF.getKey())) != null) {
            attributesBuilder.put(SemanticAttributes.MULE_APP_FLOW_SOURCE_CONFIG_REF, (Object)value);
        }
        Attributes attributes = attributesBuilder.build();
        this.muleMessageCounter.add(1L, attributes);
        this.muleMessageDurationHistogram.record((double)(transactionMeta.getEndTime().toEpochMilli() - transactionMeta.getStartTime().toEpochMilli()), attributes);
    }

    @Override
    public <T> void captureCustomMetric(MetricEventNotification<T> metricNotification) {
        if (Objects.requireNonNull(metricNotification.getMetricsInstrumentType()) == MetricsInstrumentType.COUNTER) {
            CustomMetricInstrumentHolder longCounterWrapper = this.openTelemetryConnection.getMetricInstrument(metricNotification.getMetricName());
            if (longCounterWrapper == null) {
                LOGGER.warn("{} metricNotification instrument is not configured on global configuration and will not be captured.", (Object)metricNotification.getMetricName());
                return;
            }
            Attributes attributes = Attributes.empty();
            if (metricNotification.getAttributes() != null && !metricNotification.getAttributes().isEmpty()) {
                AttributesBuilder attributesBuilder = Attributes.builder();
                metricNotification.getAttributes().forEach(attr -> attributesBuilder.put(longCounterWrapper.getAttributeKeys().get(attr.getKey()), (Object)attr.getValue()));
                attributes = attributesBuilder.build();
            }
            ((LongCounter)longCounterWrapper.getInstrument()).add(((Long)metricNotification.getMetricValue()).longValue(), attributes);
        }
    }
}

