/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.store;

import com.avioconsulting.mule.opentelemetry.internal.processor.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.store.ProcessorSpan;
import com.avioconsulting.mule.opentelemetry.internal.store.SpanMeta;
import com.avioconsulting.mule.opentelemetry.internal.store.TransactionContext;
import com.avioconsulting.mule.opentelemetry.internal.store.TransactionMeta;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import java.time.Instant;
import java.util.Map;
import java.util.function.Consumer;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.Event;

public interface TransactionStore {
    public static final String TRACE_TRANSACTION_ID = "TRACE_TRANSACTION_ID";
    public static final String TRACE_CONTEXT_MAP_KEY = "OTEL_TRACE_CONTEXT";
    public static final String TRACE_PREV_CONTEXT_MAP_KEY = "OTEL_PREV_TRACE_CONTEXT";
    public static final String TRACE_ID = "traceId";
    public static final String SPAN_ID = "spanId";

    default public String transactionIdFor(Event muleEvent) {
        return muleEvent.getCorrelationId();
    }

    public void startTransaction(TraceComponent var1, String var2, SpanBuilder var3);

    public void addTransactionTags(String var1, String var2, Map<String, String> var3);

    public TransactionContext getTransactionContext(String var1, ComponentLocation var2);

    public String getTraceIdForTransaction(String var1);

    default public void endTransaction(String transactionId, String rootFlowName) {
        this.endTransaction(transactionId, rootFlowName, null);
    }

    default public void endTransaction(String transactionId, String rootFlowName, Consumer<Span> spanUpdater) {
        this.endTransaction(transactionId, rootFlowName, spanUpdater, null);
    }

    public TransactionMeta endTransaction(String var1, String var2, Consumer<Span> var3, Instant var4);

    public void addProcessorSpan(String var1, TraceComponent var2, SpanBuilder var3);

    default public void endProcessorSpan(String transactionId, String location) {
        this.endProcessorSpan(transactionId, location, span -> {});
    }

    default public SpanMeta endProcessorSpan(String transactionId, String location, Consumer<ProcessorSpan> spanUpdater) {
        return this.endProcessorSpan(transactionId, location, spanUpdater, null);
    }

    public SpanMeta endProcessorSpan(String var1, String var2, Consumer<ProcessorSpan> var3, Instant var4);
}

