/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.logger.internal;

import com.avioconsulting.mule.logger.api.processor.AdditionalProperties;
import com.avioconsulting.mule.logger.api.processor.ExceptionProperties;
import com.avioconsulting.mule.logger.api.processor.LogProperties;
import com.avioconsulting.mule.logger.api.processor.MessageAttributes;
import com.avioconsulting.mule.logger.internal.config.CustomLoggerConfiguration;
import com.avioconsulting.mule.logger.internal.utils.CustomLoggerUtils;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectMessage;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLogger {
    private static final Logger classLogger = LoggerFactory.getLogger(CustomLogger.class);
    private static final Map<LogProperties.LogLevel, Level> levelMap = new HashMap<LogProperties.LogLevel, Level>(){
        {
            this.put(LogProperties.LogLevel.INFO, Level.INFO);
            this.put(LogProperties.LogLevel.DEBUG, Level.DEBUG);
            this.put(LogProperties.LogLevel.TRACE, Level.TRACE);
            this.put(LogProperties.LogLevel.ERROR, Level.ERROR);
            this.put(LogProperties.LogLevel.WARN, Level.WARN);
            this.put(LogProperties.LogLevel.FATAL, Level.FATAL);
        }
    };

    public void log(LogProperties logProperties, MessageAttributes messageAttributes, ExceptionProperties exceptionProperties, AdditionalProperties additionalProperties, CustomLoggerConfiguration loggerConfig, ComponentLocation location, String correlationId) {
        this.log(logProperties, messageAttributes, exceptionProperties, additionalProperties, location, correlationId, loggerConfig.getApplicationName(), loggerConfig.getApplicationVersion(), loggerConfig.getEnvironment(), loggerConfig.getDefaultCategory(), loggerConfig.isEnableV1Compatibility());
    }

    public void log(LogProperties logProperties, MessageAttributes messageAttributes, ExceptionProperties exceptionProperties, AdditionalProperties additionalProperties, ComponentLocation location, String correlationId, String applicationName, String applicationVersion, String environment, String defaultCategory, boolean enableV1Compatibility) {
        if (enableV1Compatibility) {
            this.logV1(logProperties, messageAttributes, exceptionProperties, additionalProperties, location, correlationId, applicationName, applicationVersion, environment, defaultCategory);
        } else {
            org.apache.logging.log4j.Logger logger = CustomLoggerUtils.initLogger(defaultCategory, logProperties.getCategory(), logProperties.getCategorySuffix());
            Level level = levelMap.get((Object)logProperties.getLevel());
            String correlation = logProperties.getCorrelationId() != null ? logProperties.getCorrelationId() : correlationId;
            LinkedHashMap<String, Object> logContext = new LinkedHashMap<String, Object>();
            logContext.put("timestamp", Instant.now().toString());
            logContext.put("appName", applicationName);
            logContext.put("appVersion", applicationVersion);
            logContext.put("env", environment);
            logContext.put("correlationId", correlation);
            logContext.put("message", logProperties.getMessage());
            logContext.put("messageAttributes", messageAttributes.getAttributes());
            ParameterResolver<String> payload = logProperties.getPayload();
            if (logger.isEnabled(level) && payload != null) {
                logContext.put("payload", payload.resolve());
            }
            if (exceptionProperties != null) {
                LinkedHashMap<String, String> exceptionMap = new LinkedHashMap<String, String>();
                exceptionMap.put("statusCode", exceptionProperties.getStatusCode());
                exceptionMap.put("detail", exceptionProperties.getDetail());
                logContext.put("exception", exceptionMap);
            }
            if (additionalProperties.isIncludeLocationInfo()) {
                logContext.put("location", CustomLogger.getLocationInformation(location));
            }
            Object message = "true".equalsIgnoreCase(System.getProperty("avio.logger.useMapMessage")) ? new MapMessage(logContext) : new ObjectMessage(logContext);
            logger.log(level, (Message)message);
        }
    }

    public static Map<String, String> getLocationInformation(ComponentLocation location) {
        LinkedHashMap<String, String> locationInfo = new LinkedHashMap<String, String>();
        locationInfo.put("component", location.getComponentIdentifier().getIdentifier().toString());
        locationInfo.put("rootContainer", location.getRootContainerName());
        locationInfo.put("location", location.getLocation());
        locationInfo.put("fileName", location.getFileName().orElse(""));
        locationInfo.put("lineInFile", String.valueOf(location.getLineInFile().orElse(null)));
        return locationInfo;
    }

    public void logV1(LogProperties logProperties, MessageAttributes messageAttributes, ExceptionProperties exceptionProperties, AdditionalProperties additionalProperties, ComponentLocation location, String correlationId, String applicationName, String applicationVersion, String environment, String defaultCategory) {
        org.apache.logging.log4j.Logger logger = CustomLoggerUtils.initLogger(defaultCategory, logProperties.getCategory(), logProperties.getCategorySuffix());
        HashMap<String, Object> logContext = new HashMap<String, Object>();
        logContext.put("app_name", applicationName);
        logContext.put("app_version", applicationVersion);
        logContext.put("env", environment);
        logContext.put("timestamp", Instant.now().toString());
        logContext.put("ext", messageAttributes.getAttributes());
        HashMap<String, Object> logInner = new HashMap<String, Object>();
        String cId = logProperties.getCorrelationId() != null ? logProperties.getCorrelationId() : correlationId;
        logInner.put("correlation_id", cId);
        logInner.put("message", logProperties.getMessage());
        logContext.put("log", logInner);
        Level level = levelMap.get((Object)logProperties.getLevel());
        ParameterResolver<String> payload = logProperties.getPayload();
        if (logger.isEnabled(level) && payload != null) {
            logInner.put("payload", payload.resolve());
        }
        if (exceptionProperties != null) {
            HashMap<String, String> exceptionOnes = new HashMap<String, String>();
            exceptionOnes.put("statusCode", exceptionProperties.getStatusCode());
            exceptionOnes.put("type", exceptionProperties.getType());
            exceptionOnes.put("detail", exceptionProperties.getDetail());
            logContext.put("exception", exceptionOnes);
        }
        if (additionalProperties.isIncludeLocationInfo()) {
            logContext.put("location", CustomLogger.getLocationInformation(location));
        }
        Object message = "true".equalsIgnoreCase(System.getProperty("avio.logger.useMapMessage")) ? new MapMessage(logContext) : new ObjectMessage(logContext);
        logger.log(level, (Message)message);
    }
}

