/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.logger.internal.config;

import com.avioconsulting.mule.logger.api.processor.LogProperties;
import com.avioconsulting.mule.logger.internal.CustomLogger;
import com.avioconsulting.mule.logger.internal.CustomLoggerOperation;
import com.avioconsulting.mule.logger.internal.CustomLoggerRegistrationService;
import com.avioconsulting.mule.logger.internal.CustomLoggerTimerScopeOperations;
import com.avioconsulting.mule.logger.internal.listeners.CustomLoggerNotificationListener;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operations(value={CustomLoggerOperation.class, CustomLoggerTimerScopeOperations.class})
public class CustomLoggerConfiguration
implements Startable {
    private final Logger classLogger = LoggerFactory.getLogger(CustomLoggerConfiguration.class);
    public static final String DEFAULT_CATEGORY = "com.avioconsulting.api";
    public static final String DEFAULT_APP_NAME = "#[app.name]";
    public static final String DEFAULT_ENV = "#[p('env')]";
    public static final String EXAMPLE_APP_VERSION = "#[p('appVersion')]";
    public static final String DEFAULT_FLOW_CATEGORY = "flow";
    @Parameter
    @DisplayName(value="Application Name")
    @Summary(value="Name of the MuleSoft Application")
    @Optional(defaultValue="#[app.name]")
    private String applicationName;
    @Parameter
    @DisplayName(value="Application Version")
    @Summary(value="Version of the MuleSoft Application")
    @Example(value="#[p('appVersion')]")
    private String applicationVersion;
    @Parameter
    @DisplayName(value="Environment")
    @Summary(value="MuleSoft Environment")
    @Optional(defaultValue="#[p('env')]")
    private String environment;
    @Parameter
    @DisplayName(value="Default Log Category")
    @Summary(value="A string which will be prefixed to all log category suffixes defined in the loggers")
    @Optional(defaultValue="com.avioconsulting.api")
    private String defaultCategory;
    @Parameter
    @DisplayName(value="Enable Flow Logs")
    @Summary(value="Enable flow start and stop logs which will be logged to the default category with .flow appended")
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean enableFlowLogs;
    @Parameter
    @DisplayName(value="Flow Log Level")
    @Summary(value="The level flow logs will be logged at if enabled")
    @Optional(defaultValue="DEBUG")
    private LogProperties.LogLevel flowLogLevel;
    @Parameter
    @DisplayName(value="Flow Log Category Suffix")
    @Summary(value="This category will be appended to the default logger category and used for all flow logs")
    @Optional(defaultValue="flow")
    private String flowCategorySuffix;
    @Parameter
    @DisplayName(value="Enable AVIO Logger V1 Compatibility")
    @Summary(value="This will print all log messages using the AVIO Logger V1 output format and attribute names.")
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean enableV1Compatibility;
    @Inject
    NotificationListenerRegistry notificationListenerRegistry;
    @Inject
    CustomLoggerRegistrationService customLoggerRegistrationService;
    private CustomLogger logger;
    private CustomLoggerNotificationListener notificationListener;

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getDefaultCategory() {
        return this.defaultCategory;
    }

    public CustomLogger getLogger() {
        return this.logger;
    }

    public boolean isEnableFlowLogs() {
        return this.enableFlowLogs;
    }

    public LogProperties.LogLevel getFlowLogLevel() {
        return this.flowLogLevel;
    }

    public String getFlowCategorySuffix() {
        return this.flowCategorySuffix;
    }

    public boolean isEnableV1Compatibility() {
        return this.enableV1Compatibility;
    }

    public void start() throws MuleException {
        this.classLogger.info("Starting CustomerLoggerConfiguration");
        this.logger = new CustomLogger();
        this.classLogger.info("Setting config reference on CustomLoggerRegistrationService");
        this.customLoggerRegistrationService.setConfig(this);
        if (this.isEnableFlowLogs()) {
            this.classLogger.info("Flow logs enabled, creating notification listener");
            this.notificationListener = new CustomLoggerNotificationListener(this);
            this.notificationListenerRegistry.registerListener((NotificationListener)this.notificationListener);
        } else {
            this.classLogger.info("Flow logs disabled");
        }
    }
}

