/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.logger.internal.utils;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLoggerUtils {
    private static final Logger classLogger = LoggerFactory.getLogger(CustomLoggerUtils.class);

    public static org.apache.logging.log4j.Logger initLogger(String globalCategory, String category, String categorySuffix) {
        String c = "com.avioconsulting.api";
        if (globalCategory != null && !globalCategory.equals("")) {
            c = CustomLoggerUtils.trimCategory(globalCategory);
        }
        if (categorySuffix != null && !categorySuffix.equals("")) {
            c = c + "." + CustomLoggerUtils.trimCategory(categorySuffix);
        }
        if (category != null && !category.equals("")) {
            c = CustomLoggerUtils.trimCategory(category);
        }
        return LogManager.getLogger((String)c);
    }

    private static String trimCategory(String category) {
        if (category == null || category.equals("")) {
            return category;
        }
        while (category.startsWith(".")) {
            category = category.substring(1);
        }
        while (category.endsWith(".")) {
            category = category.substring(0, category.length() - 1);
        }
        return category;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getGlobalConfigAttributes(Registry registry, String prefix, String name) {
        Map globalConfigurationProperties = null;
        String configName = prefix + ":" + name;
        Optional configurationComponentLocator = registry.lookupByType(ConfigurationComponentLocator.class);
        if (!configurationComponentLocator.isPresent()) {
            classLogger.error("Unable to find ConfigurationComponentLocator");
            throw new NoSuchElementException("Unable to find ConfigurationComponentLocator");
        }
        List globalConfigurations = ((ConfigurationComponentLocator)configurationComponentLocator.get()).find(ComponentIdentifier.builder().namespace(prefix).name(name).build());
        if (globalConfigurations.size() == 1) {
            try {
                classLogger.debug("Located " + configName + " global element, attempting to retrieve properties.");
                return (Map)((Component)globalConfigurations.get(0)).getAnnotation(QName.valueOf("{config}componentParameters"));
            }
            catch (Exception e) {
                classLogger.error("Could not retrieve properties from " + configName + " global element.");
                return globalConfigurationProperties;
            }
        }
        if (globalConfigurations.size() > 1) {
            classLogger.debug("Found more than one " + configName + ", using the last loaded configuration.");
            return (Map)((Component)globalConfigurations.get(globalConfigurations.size() - 1)).getAnnotation(QName.valueOf("{config}componentParameters"));
        }
        classLogger.error("Unable to find " + configName + " global configuration to use.  Please add an " + configName + " global configuration to your application.");
        throw new NoSuchElementException("Unable to find " + configName + " global configuration to use.  Please add an " + configName + " global configuration to your application.");
    }

    public static String retrieveValueFromGlobalConfig(ExpressionManager expressionManager, Map<String, String> globalConfigAttributes, String attributeName) throws ExpressionRuntimeException {
        if (globalConfigAttributes != null) {
            return CustomLoggerUtils.safeEvaluate(expressionManager, globalConfigAttributes.get(attributeName));
        }
        return null;
    }

    private static String safeEvaluate(ExpressionManager expressionManager, String expression) throws ExpressionRuntimeException {
        if (expression == null) {
            return "null";
        }
        if (expression.startsWith("#[")) {
            try {
                Object value = expressionManager.evaluate(expression).getValue();
                classLogger.debug(expression + " evaluated to: " + value);
                return String.valueOf(value);
            }
            catch (ExpressionRuntimeException error) {
                classLogger.error("There was an error evaluating the following expression: " + expression);
                throw error;
            }
        }
        return expression;
    }
}

