/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.logger.internal;

import com.avioconsulting.mule.logger.api.processor.AdditionalProperties;
import com.avioconsulting.mule.logger.api.processor.Compressor;
import com.avioconsulting.mule.logger.api.processor.EncryptionAlgorithm;
import com.avioconsulting.mule.logger.api.processor.ExceptionProperties;
import com.avioconsulting.mule.logger.api.processor.LogProperties;
import com.avioconsulting.mule.logger.api.processor.MessageAttributes;
import com.avioconsulting.mule.logger.internal.config.CustomLoggerConfiguration;
import com.mulesoft.modules.cryptography.api.jce.config.JceEncryptionPbeAlgorithm;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.inject.Inject;
import org.mule.extension.compression.api.strategy.gzip.GzipCompressorStrategy;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.core.api.util.Base64;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.client.DefaultOperationParameters;
import org.mule.runtime.extension.api.client.DefaultOperationParametersBuilder;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.client.OperationParameters;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public class CustomLoggerOperation {
    @Inject
    ExtensionsClient extensionsClient;

    @MediaType(value="*/*", strict=false)
    public void log(@ParameterGroup(name="Log") LogProperties logProperties, @ParameterGroup(name="Message Attributes") MessageAttributes messageAttributes, @ParameterGroup(name="Exception Details") ExceptionProperties exceptionProperties, @ParameterGroup(name="Additional Options") AdditionalProperties additionalProperties, @Config CustomLoggerConfiguration loggerConfig, ComponentLocation location, CorrelationInfo correlationInfo, StreamingHelper streamingHelper) {
        this.transformPayload(logProperties, loggerConfig, streamingHelper);
        loggerConfig.getLogger().log(logProperties, messageAttributes, exceptionProperties, additionalProperties, loggerConfig, location, correlationInfo.getCorrelationId());
    }

    byte[] convertToByteArray(Object payload, StreamingHelper streamingHelper) {
        Object resolved = streamingHelper.resolveCursorProvider(payload);
        if (resolved instanceof CursorProvider) {
            CursorStream cursorStream = (CursorStream)((CursorProvider)resolved).openCursor();
            return IOUtils.toByteArray((InputStream)cursorStream);
        }
        return null;
    }

    void transformPayload(LogProperties logProperties, CustomLoggerConfiguration loggerConfig, StreamingHelper streamingHelper) {
        ParameterResolver<String> payload = logProperties.getPayload();
        if (payload == null) {
            return;
        }
        Result<InputStream, Void> executeCompress = null;
        executeCompress = this.setCompressedPayloadIfNeeded(logProperties, streamingHelper, loggerConfig);
        this.setEncryptedPayloadIfNeeded(logProperties, loggerConfig, streamingHelper, executeCompress);
    }

    Result<InputStream, Void> setCompressedPayloadIfNeeded(LogProperties logProperties, StreamingHelper streamingHelper, CustomLoggerConfiguration loggerConfig) {
        Result executeCompress = null;
        Compressor compressor = loggerConfig.getCompressor();
        if (compressor != null) {
            GzipCompressorStrategy compressorStrategy = new GzipCompressorStrategy();
            DefaultOperationParametersBuilder parametersBuilder = DefaultOperationParameters.builder().addParameter("content", (Object)new ByteArrayInputStream(((String)logProperties.getPayload().resolve()).getBytes())).addParameter("compressor", (Object)compressorStrategy);
            try {
                executeCompress = this.extensionsClient.execute("Compression", "compress", (OperationParameters)parametersBuilder.build());
                String compressedString = Base64.encodeBytes((byte[])this.convertToByteArray(executeCompress.getOutput(), streamingHelper));
                logProperties.setCompressedPayload(compressedString);
            }
            catch (Exception e) {
                throw new RuntimeException("Compression Exception", e);
            }
        }
        return executeCompress;
    }

    void setEncryptedPayloadIfNeeded(LogProperties logProperties, CustomLoggerConfiguration loggerConfig, StreamingHelper streamingHelper, Result<InputStream, Void> executeCompress) {
        EncryptionAlgorithm encryptionAlgorithm = loggerConfig.getEncryptionAlgorithm();
        if (encryptionAlgorithm != null) {
            JceEncryptionPbeAlgorithm jceEncryptionPbeAlgorithm = JceEncryptionPbeAlgorithm.valueOf((String)encryptionAlgorithm.toString());
            ByteArrayInputStream content = executeCompress != null ? new ByteArrayInputStream(this.convertToByteArray(executeCompress.getOutput(), streamingHelper)) : new ByteArrayInputStream(((String)logProperties.getPayload().resolve()).getBytes());
            DefaultOperationParametersBuilder encryptionParametersBuilder = DefaultOperationParameters.builder().addParameter("content", (Object)content).addParameter("algorithm", (Object)jceEncryptionPbeAlgorithm).addParameter("password", (Object)loggerConfig.getEncryptionPassword());
            try {
                Result executeEncrypt = this.extensionsClient.execute("Crypto", "jceEncryptPbe", (OperationParameters)encryptionParametersBuilder.build());
                String encryptedString = Base64.encodeBytes((byte[])this.convertToByteArray(executeEncrypt.getOutput(), streamingHelper));
                logProperties.setEncryptedPayload(encryptedString);
            }
            catch (Exception e) {
                throw new RuntimeException("Encryption Error", e);
            }
        }
    }
}

