/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.logger.internal.listeners;

import com.avioconsulting.mule.logger.api.processor.AdditionalProperties;
import com.avioconsulting.mule.logger.api.processor.ExceptionProperties;
import com.avioconsulting.mule.logger.api.processor.LogProperties;
import com.avioconsulting.mule.logger.api.processor.MessageAttributes;
import com.avioconsulting.mule.logger.internal.CustomLogger;
import com.avioconsulting.mule.logger.internal.config.CustomLoggerConfiguration;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.api.notification.PipelineMessageNotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLoggerNotificationListener
implements PipelineMessageNotificationListener<PipelineMessageNotification> {
    private final Logger classLogger = LoggerFactory.getLogger(CustomLoggerNotificationListener.class);
    private final CustomLoggerConfiguration config;

    public CustomLoggerNotificationListener(CustomLoggerConfiguration config) {
        this.config = config;
    }

    public void onNotification(PipelineMessageNotification notification) {
        this.classLogger.debug("Received Notification [" + notification.getClass().getName() + ":" + notification.getActionName() + "]");
        if (this.config != null) {
            try {
                ComponentLocation location = notification.getComponent().getLocation();
                CustomLogger logger = this.config.getLogger();
                LogProperties logProperties = new LogProperties();
                MessageAttributes messageAttributes = new MessageAttributes();
                if (notification.getEvent().getVariables().get("OTEL_TRACE_CONTEXT") != null) {
                    Object oTelContextObject = ((TypedValue)notification.getEvent().getVariables().get("OTEL_TRACE_CONTEXT")).getValue();
                    messageAttributes.setOTelContextObject(oTelContextObject);
                }
                ExceptionProperties exceptionProperties = new ExceptionProperties();
                AdditionalProperties additionalProperties = new AdditionalProperties();
                additionalProperties.setIncludeLocationInfo(true);
                String correlationId = notification.getEvent().getCorrelationId();
                if (this.config.getFlowCategorySuffix() != null && !this.config.getFlowCategorySuffix().equals("")) {
                    logProperties.setCategorySuffix(this.config.getFlowCategorySuffix());
                }
                logProperties.setLevel(this.config.getFlowLogLevel());
                String logMessage = "Event not processed yet, this should never be shown";
                switch (Integer.parseInt(notification.getAction().getIdentifier())) {
                    case 1801: {
                        logMessage = "Flow [" + notification.getResourceIdentifier() + "] start";
                        break;
                    }
                    case 1804: {
                        logMessage = "Flow [" + notification.getResourceIdentifier() + "] end";
                        break;
                    }
                    default: {
                        this.classLogger.debug("Not a flow start or complete event being processed, existing without logging.");
                        return;
                    }
                }
                this.classLogger.debug(logMessage);
                logProperties.setMessage(logMessage);
                logger.log(logProperties, messageAttributes, exceptionProperties, additionalProperties, this.config, location, correlationId);
            }
            catch (Exception e) {
                this.classLogger.error("Error processing flow notification", (Throwable)e);
            }
        } else {
            this.classLogger.warn("Configuration hasn't been supplied to notification listener yet, flow logs won't be generated.");
        }
    }
}

