/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.logger.internal.config;

import com.avioconsulting.mule.logger.api.processor.Compressor;
import com.avioconsulting.mule.logger.api.processor.EncryptionAlgorithm;
import com.avioconsulting.mule.logger.api.processor.LogProperties;
import com.avioconsulting.mule.logger.internal.CustomLogger;
import com.avioconsulting.mule.logger.internal.CustomLoggerOperation;
import com.avioconsulting.mule.logger.internal.CustomLoggerRegistrationService;
import com.avioconsulting.mule.logger.internal.CustomLoggerTimerScopeOperations;
import com.avioconsulting.mule.logger.internal.listeners.CustomLoggerFlowRefNotificationListener;
import com.avioconsulting.mule.logger.internal.listeners.CustomLoggerPipelineNotificationListener;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operations(value={CustomLoggerOperation.class, CustomLoggerTimerScopeOperations.class})
public class CustomLoggerConfiguration
implements Startable,
Initialisable {
    private final Logger classLogger = LoggerFactory.getLogger(CustomLoggerConfiguration.class);
    public static final String DEFAULT_CATEGORY = "com.avioconsulting.api";
    public static final String DEFAULT_APP_NAME = "${app.name}";
    public static final String DEFAULT_ENV = "${env}";
    public static final String DEFAULT_APP_VERSION = "${app.version}";
    public static final String DEFAULT_FLOW_CATEGORY = "flow";
    @Parameter
    @DisplayName(value="Application Name")
    @Summary(value="Name of the MuleSoft Application")
    @Optional(defaultValue="${app.name}")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String applicationName;
    @Parameter
    @DisplayName(value="Application Version")
    @Summary(value="Version of the MuleSoft Application")
    @Optional(defaultValue="${app.version}")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String applicationVersion;
    @Parameter
    @DisplayName(value="Environment")
    @Summary(value="MuleSoft Environment")
    @Optional(defaultValue="${env}")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String environment;
    @Parameter
    @DisplayName(value="Default Log Category")
    @Summary(value="A string which will be prefixed to all log category suffixes defined in the loggers")
    @Optional(defaultValue="com.avioconsulting.api")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String defaultCategory;
    @Parameter
    @DisplayName(value="Enable Flow Logs")
    @Summary(value="Enable flow start and stop logs which will be logged to the default category with .flow appended")
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean enableFlowLogs;
    @Parameter
    @DisplayName(value="Flow Log Level")
    @Summary(value="The level flow logs will be logged at if enabled")
    @Optional(defaultValue="DEBUG")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private LogProperties.LogLevel flowLogLevel;
    @Parameter
    @DisplayName(value="Flow Log Category Suffix")
    @Summary(value="This category will be appended to the default logger category and used for all flow logs")
    @Optional(defaultValue="flow")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String flowCategorySuffix;
    @Parameter
    @DisplayName(value="Enable AVIO Logger V1 Compatibility")
    @Summary(value="This will print all log messages using the AVIO Logger V1 output format and attribute names.")
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean enableV1Compatibility;
    @Parameter
    @DisplayName(value="Format Message as JSON String")
    @Summary(value="Writes the Log message as JSON String. This can be useful where appenders (eg. OpenTelemetry) does not support using layouts but backend system requires a JSON formatted message.")
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean formatAsJson;
    @Parameter
    @DisplayName(value="Compression Strategy")
    @Summary(value="Enumerated Compression Strategy value to compress payload before logging")
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Compression", order=1)
    private Compressor compressor;
    @Parameter
    @DisplayName(value="Encryption Algorithm (with JCEwithPBE)")
    @Summary(value="Choose an encryption algorithm from the enumerated list to use in conjunction with the password to encrypt the payload before logging")
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Encryption", order=1)
    private EncryptionAlgorithm encryptionAlgorithm;
    @Parameter
    @DisplayName(value="Encryption Password")
    @Summary(value="Password to use with encryption algorithm to encrypt payload value")
    @Optional
    @Password
    @Placement(tab="Encryption", order=2)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String encryptionPassword;
    @Inject
    NotificationListenerRegistry notificationListenerRegistry;
    @Inject
    CustomLoggerRegistrationService customLoggerRegistrationService;
    @Inject
    ExtensionsClient extensionsClient;
    private CustomLogger logger;
    private CustomLoggerPipelineNotificationListener notificationListener;
    private static boolean isNotificationListenerRegistered = false;

    public CustomLoggerConfiguration() {
    }

    public CustomLoggerConfiguration(CustomLoggerRegistrationService customLoggerRegistrationService, NotificationListenerRegistry notificationListenerRegistry, ExtensionsClient extensionsClient) {
        this.customLoggerRegistrationService = customLoggerRegistrationService;
        this.notificationListenerRegistry = notificationListenerRegistry;
        this.extensionsClient = extensionsClient;
    }

    public CustomLoggerConfiguration(CustomLoggerRegistrationService customLoggerRegistrationService, NotificationListenerRegistry notificationListenerRegistry) {
        this.customLoggerRegistrationService = customLoggerRegistrationService;
        this.notificationListenerRegistry = notificationListenerRegistry;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public CustomLoggerConfiguration setApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public CustomLoggerConfiguration setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
        return this;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public CustomLoggerConfiguration setEnvironment(String environment) {
        this.environment = environment;
        return this;
    }

    public String getDefaultCategory() {
        return this.defaultCategory;
    }

    public CustomLoggerConfiguration setDefaultCategory(String defaultCategory) {
        this.defaultCategory = defaultCategory;
        return this;
    }

    public boolean isEnableFlowLogs() {
        return this.enableFlowLogs;
    }

    public CustomLoggerConfiguration setEnableFlowLogs(boolean enableFlowLogs) {
        this.enableFlowLogs = enableFlowLogs;
        return this;
    }

    public LogProperties.LogLevel getFlowLogLevel() {
        return this.flowLogLevel;
    }

    public CustomLoggerConfiguration setFlowLogLevel(LogProperties.LogLevel flowLogLevel) {
        this.flowLogLevel = flowLogLevel;
        return this;
    }

    public String getFlowCategorySuffix() {
        return this.flowCategorySuffix;
    }

    public CustomLoggerConfiguration setFlowCategorySuffix(String flowCategorySuffix) {
        this.flowCategorySuffix = flowCategorySuffix;
        return this;
    }

    public boolean isEnableV1Compatibility() {
        return this.enableV1Compatibility;
    }

    public CustomLoggerConfiguration setEnableV1Compatibility(boolean enableV1Compatibility) {
        this.enableV1Compatibility = enableV1Compatibility;
        return this;
    }

    public boolean isFormatAsJson() {
        return this.formatAsJson;
    }

    public CustomLoggerConfiguration setFormatAsJson(boolean formatAsJson) {
        this.formatAsJson = formatAsJson;
        return this;
    }

    public Compressor getCompressor() {
        return this.compressor;
    }

    public CustomLoggerConfiguration setCompressor(Compressor compressor) {
        this.compressor = compressor;
        return this;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public CustomLoggerConfiguration setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    public String getEncryptionPassword() {
        return this.encryptionPassword;
    }

    public CustomLoggerConfiguration setEncryptionPassword(String encryptionPassword) {
        this.encryptionPassword = encryptionPassword;
        return this;
    }

    public CustomLogger getLogger() {
        return this.logger;
    }

    public ExtensionsClient getExtensionsClient() {
        return this.extensionsClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws MuleException {
        this.classLogger.info("Starting CustomerLoggerConfiguration");
        this.logger = new CustomLogger();
        this.classLogger.info("Setting config reference on CustomLoggerRegistrationService");
        this.customLoggerRegistrationService.setConfig(this);
        if (this.isEnableFlowLogs()) {
            this.classLogger.info("Flow logs enabled");
            Class<CustomLoggerConfiguration> clazz = CustomLoggerConfiguration.class;
            synchronized (CustomLoggerConfiguration.class) {
                if (!isNotificationListenerRegistered) {
                    this.classLogger.info("Creating and registering notification listener");
                    this.notificationListener = new CustomLoggerPipelineNotificationListener(this);
                    this.notificationListenerRegistry.registerListener((NotificationListener)this.notificationListener);
                    this.notificationListenerRegistry.registerListener((NotificationListener)new CustomLoggerFlowRefNotificationListener(this));
                    isNotificationListenerRegistered = true;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else {
            this.classLogger.info("Flow logs disabled");
        }
    }

    public void initialise() throws InitialisationException {
        EncryptionAlgorithm encryptionAlgorithm = this.getEncryptionAlgorithm();
        String encryptionPassword = this.getEncryptionPassword();
        if (encryptionAlgorithm != null && encryptionPassword == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Encryption Password must be provided if encryption algorithm is being used"), (Initialisable)this);
        }
        if (encryptionAlgorithm == null && encryptionPassword != null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Encryption Algorithm must be provided if encryption password is being supplied"), (Initialisable)this);
        }
    }
}

