/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.logger.internal.listeners;

import com.avioconsulting.mule.logger.internal.config.CustomLoggerConfiguration;
import com.avioconsulting.mule.logger.internal.listeners.CustomLoggerAbstractNotificationListener;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.api.notification.PipelineMessageNotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLoggerPipelineNotificationListener
extends CustomLoggerAbstractNotificationListener
implements PipelineMessageNotificationListener<PipelineMessageNotification> {
    private final Logger classLogger = LoggerFactory.getLogger(CustomLoggerPipelineNotificationListener.class);

    public CustomLoggerPipelineNotificationListener(CustomLoggerConfiguration config) {
        super(config);
    }

    @Override
    public Logger getClassLogger() {
        return this.classLogger;
    }

    public void onNotification(PipelineMessageNotification notification) {
        this.classLogger.debug("Received Notification [" + notification.getClass().getName() + ":" + notification.getActionName() + "]");
        if (this.config != null) {
            try {
                String message = "Event not processed yet, this should never be shown";
                switch (Integer.parseInt(notification.getAction().getIdentifier())) {
                    case 1801: {
                        message = "Flow [" + notification.getResourceIdentifier() + "] start";
                        break;
                    }
                    case 1804: {
                        message = "Flow [" + notification.getResourceIdentifier() + "] end";
                        break;
                    }
                    default: {
                        this.classLogger.debug("Not a flow start or complete event being processed, existing without logging.");
                        return;
                    }
                }
                this.classLogger.debug(message);
                this.logMessage(notification.getComponent().getLocation(), notification.getEvent(), message, this.config.getFlowCategorySuffix(), this.config.getFlowLogLevel());
            }
            catch (Exception e) {
                this.classLogger.error("Error processing flow notification", (Throwable)e);
            }
        } else {
            this.classLogger.warn("Configuration hasn't been supplied to notification listener yet, flow logs won't be generated.");
        }
    }
}

