/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.logger.api.processor;

import com.avioconsulting.mule.logger.api.processor.MessageAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;

public class MessageAttributes {
    @Parameter
    @Optional(defaultValue="#[vars.OTEL_TRACE_CONTEXT]")
    @Expression(value=ExpressionSupport.REQUIRED)
    @ParameterDsl(allowInlineDefinition=false, allowReferences=false)
    @DisplayName(value="OpenTelemetry Context")
    @Summary(value="The object that contains the open telemetry context variables to add the log message attributes. If you are using AVIO's Open Telemetry Module there is no more configuration necessary")
    private ParameterResolver<TypedValue<Object>> oTelContext;
    @Parameter
    @DisplayName(value="Message Attributes")
    @Optional
    @NullSafe
    @Summary(value="Discrete data elements you want to log as key value pairs.  Useful for adding data fields for reporting in log aggregation tools")
    private List<MessageAttribute> messageAttributes = new ArrayList<MessageAttribute>();
    private Object oTelContextObject;

    public List<MessageAttribute> getAttributeList() {
        return this.messageAttributes;
    }

    public void addAttributes(Map<String, String> attributes) {
        attributes.forEach((key, value) -> this.messageAttributes.add(new MessageAttribute((String)key, (String)value)));
    }

    public Map<String, String> getAttributes() {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        if (this.messageAttributes != null) {
            for (MessageAttribute a : this.messageAttributes) {
                attributes.put(a.getKey(), a.getValue());
            }
        }
        return attributes;
    }

    public ParameterResolver<TypedValue<Object>> getOTelContext() {
        return this.oTelContext;
    }

    public void setOTelContext(ParameterResolver<TypedValue<Object>> oTelContext) {
        this.oTelContext = oTelContext;
    }

    public Object getOTelContextObject() {
        if (this.oTelContextObject != null) {
            return this.oTelContextObject;
        }
        if (this.oTelContext != null) {
            return ((TypedValue)this.oTelContext.resolve()).getValue();
        }
        return null;
    }

    public void setOTelContextObject(Object oTelContextObject) {
        this.oTelContextObject = oTelContextObject;
    }
}

