/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.logger.internal.listeners;

import com.avioconsulting.mule.logger.api.processor.AdditionalProperties;
import com.avioconsulting.mule.logger.api.processor.ExceptionProperties;
import com.avioconsulting.mule.logger.api.processor.FlowLogConfig;
import com.avioconsulting.mule.logger.api.processor.LogProperties;
import com.avioconsulting.mule.logger.api.processor.MessageAttributes;
import com.avioconsulting.mule.logger.internal.CustomLogger;
import com.avioconsulting.mule.logger.internal.config.CustomLoggerConfiguration;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.slf4j.Logger;

public abstract class CustomLoggerAbstractNotificationListener {
    protected final CustomLoggerConfiguration config;
    private Map<String, String> emptyAttributes = Collections.emptyMap();

    public CustomLoggerAbstractNotificationListener(CustomLoggerConfiguration config) {
        this.config = config;
    }

    protected abstract Logger getClassLogger();

    protected void logMessage(ComponentLocation location, Event event, String logMessage, String categoryPrefix, LogProperties.LogLevel level, Map<String, String> additionalAttributes) {
        CustomLogger logger = this.config.getLogger();
        LogProperties logProperties = new LogProperties();
        MessageAttributes messageAttributes = new MessageAttributes();
        if (event.getVariables().get("OTEL_TRACE_CONTEXT") != null) {
            Object oTelContextObject = ((TypedValue)event.getVariables().get("OTEL_TRACE_CONTEXT")).getValue();
            messageAttributes.setOTelContextObject(oTelContextObject);
        }
        messageAttributes.addAttributes(additionalAttributes);
        ExceptionProperties exceptionProperties = new ExceptionProperties();
        AdditionalProperties additionalProperties = new AdditionalProperties();
        additionalProperties.setIncludeLocationInfo(true);
        String correlationId = event.getCorrelationId();
        if (categoryPrefix != null && !categoryPrefix.isEmpty()) {
            logProperties.setCategorySuffix(categoryPrefix);
        }
        logProperties.setLevel(level);
        logProperties.setMessage(logMessage);
        logger.log(logProperties, messageAttributes, exceptionProperties, additionalProperties, this.config, location, correlationId);
    }

    protected Map<String, String> getFlowLogAttributes(EnrichedServerNotification notification) {
        Map<String, String> value = this.emptyAttributes;
        Optional<Map.Entry> matchedEntry = this.config.getFlowLogConfigMap().entrySet().stream().filter(entry -> this.matchWildcard((String)entry.getKey(), notification.getResourceIdentifier())).findFirst();
        if (matchedEntry.isPresent()) {
            FlowLogConfig flowLogConfig = (FlowLogConfig)matchedEntry.get().getValue();
            TypedValue evaluate = this.config.getExpressionManager().evaluate("#[" + flowLogConfig.getAttributesExpressionText() + "]", notification.getEvent().asBindingContext());
            value = (Map<String, String>)evaluate.getValue();
            if (value == null) {
                value = this.emptyAttributes;
            }
        }
        return value;
    }

    public boolean matchWildcard(String wildcardKey, String searchString) {
        String cleanWildcardKey = wildcardKey.trim();
        if (searchString.equalsIgnoreCase(wildcardKey)) {
            return true;
        }
        if (cleanWildcardKey.startsWith("*")) {
            String suffix = cleanWildcardKey.substring(1);
            return searchString.endsWith(suffix);
        }
        if (cleanWildcardKey.endsWith("*")) {
            String prefix = cleanWildcardKey.substring(0, cleanWildcardKey.length() - 1);
            return searchString.startsWith(prefix);
        }
        return cleanWildcardKey.equals("*");
    }
}

