/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.logger.internal.listeners;

import com.avioconsulting.mule.logger.internal.config.CustomLoggerConfiguration;
import com.avioconsulting.mule.logger.internal.listeners.CustomLoggerAbstractNotificationListener;
import java.util.Map;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.MessageProcessorNotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLoggerFlowRefNotificationListener
extends CustomLoggerAbstractNotificationListener
implements MessageProcessorNotificationListener<MessageProcessorNotification> {
    private final Logger classLogger = LoggerFactory.getLogger(CustomLoggerFlowRefNotificationListener.class);
    private final QName QNAME_COMPONENT_PARAMS = QName.valueOf("{config}componentParameters");
    private final String FLOW_REF_CATEGORY_SUFFIX;

    public CustomLoggerFlowRefNotificationListener(CustomLoggerConfiguration config) {
        super(config);
        this.FLOW_REF_CATEGORY_SUFFIX = config.getFlowCategorySuffix().concat(".flow-ref");
    }

    @Override
    public Logger getClassLogger() {
        return this.classLogger;
    }

    public void onNotification(MessageProcessorNotification notification) {
        this.classLogger.debug("Received Notification [{}:{} for component {}]", new Object[]{notification.getClass().getName(), notification.getActionName(), notification.getComponent()});
        if (this.config != null) {
            try {
                ComponentLocation location = notification.getComponent().getLocation();
                if (!"flow-ref".equalsIgnoreCase(location.getComponentIdentifier().getIdentifier().getName())) {
                    return;
                }
                Map params = (Map)notification.getComponent().getAnnotation(this.QNAME_COMPONENT_PARAMS);
                String flowRefTarget = (String)params.get("name");
                String message = "Event not processed yet, this should never be shown";
                switch (Integer.parseInt(notification.getAction().getIdentifier())) {
                    case 1601: {
                        message = "Flow-ref with target [" + flowRefTarget + "] start";
                        break;
                    }
                    case 1602: {
                        message = "Flow-ref with target [" + flowRefTarget + "] end";
                        break;
                    }
                    default: {
                        this.classLogger.debug("Not a flow-ref pre or post event being processed, existing without logging.");
                        return;
                    }
                }
                this.classLogger.info(message);
                Map<String, String> flowLogAttributes = this.getFlowLogAttributes((EnrichedServerNotification)notification);
                this.logMessage(location, notification.getEvent(), message, this.FLOW_REF_CATEGORY_SUFFIX, this.config.getFlowLogLevel(), flowLogAttributes);
            }
            catch (Exception e) {
                this.classLogger.error("Error processing flow notification", (Throwable)e);
            }
        } else {
            this.classLogger.debug("Configuration hasn't been supplied to notification listener yet, flow logs won't be generated.");
        }
    }
}

