/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.logger.internal;

import com.avioconsulting.mule.logger.api.processor.AdditionalProperties;
import com.avioconsulting.mule.logger.api.processor.ExceptionProperties;
import com.avioconsulting.mule.logger.api.processor.LogProperties;
import com.avioconsulting.mule.logger.api.processor.MessageAttribute;
import com.avioconsulting.mule.logger.api.processor.MessageAttributes;
import com.avioconsulting.mule.logger.internal.config.CustomLoggerConfiguration;
import com.avioconsulting.mule.logger.internal.utils.CustomLoggerUtils;
import com.avioconsulting.mule.logger.internal.utils.PayloadTransformer;
import com.google.gson.Gson;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLogger {
    private static final Logger classLogger = LoggerFactory.getLogger(CustomLogger.class);
    private static final Map<LogProperties.LogLevel, Level> levelMap = new HashMap<LogProperties.LogLevel, Level>();
    public PayloadTransformer payloadTransformer = new PayloadTransformer();
    private static final DateTimeFormatter dateTimeFormatter;

    public void log(LogProperties logProperties, MessageAttributes messageAttributes, ExceptionProperties exceptionProperties, AdditionalProperties additionalProperties, CustomLoggerConfiguration loggerConfig, ComponentLocation location, String correlationId) {
        this.log(logProperties, messageAttributes, exceptionProperties, additionalProperties, loggerConfig, location, correlationId, null);
    }

    public void log(LogProperties logProperties, MessageAttributes messageAttributes, ExceptionProperties exceptionProperties, AdditionalProperties additionalProperties, CustomLoggerConfiguration loggerConfig, ComponentLocation location, String correlationId, StreamingHelper streamingHelper) {
        this.log(logProperties, messageAttributes, exceptionProperties, additionalProperties, location, correlationId, loggerConfig, streamingHelper);
    }

    public void log(LogProperties logProperties, MessageAttributes messageAttributes, ExceptionProperties exceptionProperties, AdditionalProperties additionalProperties, ComponentLocation location, String correlationId, CustomLoggerConfiguration loggerConfig, StreamingHelper streamingHelper) {
        String applicationName = loggerConfig.getApplicationName();
        String applicationVersion = loggerConfig.getApplicationVersion();
        String environment = loggerConfig.getEnvironment();
        String defaultCategory = loggerConfig.getDefaultCategory();
        boolean enableV1Compatibility = loggerConfig.isEnableV1Compatibility();
        boolean formatAsJson = loggerConfig.isFormatAsJson();
        if (enableV1Compatibility) {
            this.logV1(logProperties, messageAttributes, exceptionProperties, additionalProperties, location, correlationId, applicationName, applicationVersion, environment, defaultCategory, formatAsJson);
        } else {
            org.apache.logging.log4j.Logger logger = CustomLoggerUtils.initLogger(defaultCategory, logProperties.getCategory(), logProperties.getCategorySuffix());
            Level level = levelMap.get((Object)logProperties.getLevel());
            String correlation = logProperties.getCorrelationId() != null ? logProperties.getCorrelationId() : correlationId;
            Object oTelContext = messageAttributes.getOTelContextObject();
            LinkedHashMap<String, Object> logContext = new LinkedHashMap<String, Object>();
            logContext.put("timestamp", dateTimeFormatter.format(Instant.now()));
            logContext.put("appName", applicationName);
            logContext.put("appVersion", applicationVersion);
            logContext.put("env", environment);
            logContext.put("correlationId", correlation);
            logContext.put("message", logProperties.getMessage());
            if (oTelContext != null) {
                Map oTelContextMap = (Map)oTelContext;
                MessageAttribute traceId = new MessageAttribute("traceId", (String)oTelContextMap.get("traceId"));
                messageAttributes.getAttributeList().add(traceId);
                MessageAttribute traceIdLongLowPart = new MessageAttribute("traceIdLongLowPart", (String)oTelContextMap.get("traceIdLongLowPart"));
                messageAttributes.getAttributeList().add(traceIdLongLowPart);
                MessageAttribute spanId = new MessageAttribute("spanId", (String)oTelContextMap.get("spanId"));
                messageAttributes.getAttributeList().add(spanId);
                MessageAttribute spanIdLong = new MessageAttribute("spanIdLong", (String)oTelContextMap.get("spanIdLong"));
                messageAttributes.getAttributeList().add(spanIdLong);
            }
            logContext.put("messageAttributes", messageAttributes.getAttributes());
            ParameterResolver<String> payload = logProperties.getPayload();
            if (logger.isEnabled(level) && payload != null) {
                String payloadString = (String)payload.resolve();
                if (streamingHelper != null) {
                    payloadString = this.payloadTransformer.transformPayload(loggerConfig, streamingHelper, payloadString);
                }
                logContext.put("payload", payloadString);
            }
            if (exceptionProperties != null) {
                LinkedHashMap<String, String> exceptionMap = new LinkedHashMap<String, String>();
                exceptionMap.put("statusCode", exceptionProperties.getStatusCode());
                exceptionMap.put("detail", exceptionProperties.getDetail());
                logContext.put("exception", exceptionMap);
            }
            if (additionalProperties.isIncludeLocationInfo()) {
                logContext.put("location", CustomLogger.getLocationInformation(location));
            }
            this.writeLog(logContext, logger, level, formatAsJson);
        }
    }

    private void writeLog(Map<String, Object> logContext, org.apache.logging.log4j.Logger logger, Level level, boolean formatAsJson) {
        MapMessage message;
        if ("true".equalsIgnoreCase(System.getProperty("avio.logger.useMapMessage"))) {
            message = new MapMessage(logContext);
        } else if (formatAsJson) {
            Gson gson = new Gson();
            String json = gson.toJson(logContext);
            message = new SimpleMessage(json);
        } else {
            message = new ObjectMessage(logContext);
        }
        logger.log(level, (Message)message);
    }

    public static Map<String, String> getLocationInformation(ComponentLocation location) {
        LinkedHashMap<String, String> locationInfo = new LinkedHashMap<String, String>();
        locationInfo.put("component", location.getComponentIdentifier().getIdentifier().toString());
        locationInfo.put("rootContainer", location.getRootContainerName());
        locationInfo.put("location", location.getLocation());
        locationInfo.put("fileName", location.getFileName().orElse(""));
        locationInfo.put("lineInFile", String.valueOf(location.getLineInFile().orElse(null)));
        return locationInfo;
    }

    public void logV1(LogProperties logProperties, MessageAttributes messageAttributes, ExceptionProperties exceptionProperties, AdditionalProperties additionalProperties, ComponentLocation location, String correlationId, String applicationName, String applicationVersion, String environment, String defaultCategory, boolean formatAsJson) {
        org.apache.logging.log4j.Logger logger = CustomLoggerUtils.initLogger(defaultCategory, logProperties.getCategory(), logProperties.getCategorySuffix());
        HashMap<String, Object> logContext = new HashMap<String, Object>();
        logContext.put("app_name", applicationName);
        logContext.put("app_version", applicationVersion);
        logContext.put("env", environment);
        logContext.put("timestamp", Instant.now().toString());
        logContext.put("ext", messageAttributes.getAttributes());
        HashMap<String, Object> logInner = new HashMap<String, Object>();
        String cId = logProperties.getCorrelationId() != null ? logProperties.getCorrelationId() : correlationId;
        logInner.put("correlation_id", cId);
        logInner.put("message", logProperties.getMessage());
        logContext.put("log", logInner);
        Level level = levelMap.get((Object)logProperties.getLevel());
        ParameterResolver<String> payload = logProperties.getPayload();
        if (logger.isEnabled(level) && payload != null) {
            logInner.put("payload", payload.resolve());
        }
        if (exceptionProperties != null) {
            HashMap<String, String> exceptionOnes = new HashMap<String, String>();
            exceptionOnes.put("statusCode", exceptionProperties.getStatusCode());
            exceptionOnes.put("type", exceptionProperties.getType());
            exceptionOnes.put("detail", exceptionProperties.getDetail());
            logContext.put("exception", exceptionOnes);
        }
        if (additionalProperties.isIncludeLocationInfo()) {
            logContext.put("location", CustomLogger.getLocationInformation(location));
        }
        this.writeLog(logContext, logger, level, formatAsJson);
    }

    static {
        levelMap.put(LogProperties.LogLevel.FATAL, Level.FATAL);
        levelMap.put(LogProperties.LogLevel.WARN, Level.WARN);
        levelMap.put(LogProperties.LogLevel.ERROR, Level.ERROR);
        levelMap.put(LogProperties.LogLevel.TRACE, Level.TRACE);
        levelMap.put(LogProperties.LogLevel.DEBUG, Level.DEBUG);
        levelMap.put(LogProperties.LogLevel.INFO, Level.INFO);
        dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(ZoneId.of("UTC"));
    }
}

