/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.logger.internal.listeners;

import com.avioconsulting.mule.logger.api.processor.FlowLogConfig;
import com.avioconsulting.mule.logger.internal.config.CustomLoggerConfiguration;
import com.avioconsulting.mule.logger.internal.listeners.CustomLoggerAbstractNotificationListener;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.api.notification.PipelineMessageNotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomLoggerPipelineNotificationListener
extends CustomLoggerAbstractNotificationListener
implements PipelineMessageNotificationListener<PipelineMessageNotification> {
    private final Logger classLogger = LoggerFactory.getLogger(CustomLoggerPipelineNotificationListener.class);

    public CustomLoggerPipelineNotificationListener(CustomLoggerConfiguration config) {
        super(config);
    }

    @Override
    public Logger getClassLogger() {
        return this.classLogger;
    }

    public void onNotification(PipelineMessageNotification notification) {
        this.classLogger.debug("Received Notification [" + notification.getClass().getName() + ":" + notification.getActionName() + "]");
        if (this.config != null) {
            try {
                String msgToAppend = "";
                Optional<Map.Entry> matchedEntry = this.config.getFlowLogConfigMap().entrySet().stream().filter(entry -> this.matchWildcard((String)entry.getKey(), notification.getResourceIdentifier())).findFirst();
                if (matchedEntry.isPresent()) {
                    FlowLogConfig flowLogConfig = (FlowLogConfig)matchedEntry.get().getValue();
                    TypedValue evaluate = this.config.getExpressionManager().evaluate("#[" + flowLogConfig.getMessageExpressionText() + "]", notification.getEvent().asBindingContext());
                    msgToAppend = (String)evaluate.getValue();
                }
                String message = "Event not processed yet, this should never be shown";
                switch (Integer.parseInt(notification.getAction().getIdentifier())) {
                    case 1801: {
                        message = "Flow [" + notification.getResourceIdentifier() + "] start " + (msgToAppend != null ? msgToAppend : "");
                        break;
                    }
                    case 1804: {
                        message = "Flow [" + notification.getResourceIdentifier() + "] end";
                        break;
                    }
                    default: {
                        this.classLogger.debug("Not a flow start or complete event being processed, existing without logging.");
                        return;
                    }
                }
                this.classLogger.debug(message);
                Map<String, String> flowLogAttributes = this.getFlowLogAttributes((EnrichedServerNotification)notification);
                this.logMessage(notification.getComponent().getLocation(), notification.getEvent(), message, this.config.getFlowCategorySuffix(), this.config.getFlowLogLevel(), flowLogAttributes);
            }
            catch (ClassCastException castException) {
                this.classLogger.error("Message expression text in flow-log-config needs to be a String", (Throwable)castException);
            }
            catch (Exception e) {
                this.classLogger.error("Error processing flow notification", (Throwable)e);
            }
        } else {
            this.classLogger.warn("Configuration hasn't been supplied to notification listener yet, flow logs won't be generated.");
        }
    }
}

