/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.logger.internal.utils;

import com.avioconsulting.mule.logger.api.processor.Compressor;
import com.avioconsulting.mule.logger.api.processor.EncryptionAlgorithm;
import com.avioconsulting.mule.logger.internal.config.CustomLoggerConfiguration;
import com.mulesoft.modules.cryptography.api.jce.config.JceEncryptionPbeAlgorithm;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.mule.extension.compression.api.strategy.gzip.GzipCompressorStrategy;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.core.api.util.Base64;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.client.DefaultOperationParameters;
import org.mule.runtime.extension.api.client.DefaultOperationParametersBuilder;
import org.mule.runtime.extension.api.client.OperationParameters;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public class PayloadTransformer {
    public byte[] convertToByteArray(Object payload, StreamingHelper streamingHelper) {
        Object resolved = streamingHelper.resolveCursorProvider(payload);
        if (resolved instanceof CursorProvider) {
            CursorStream cursorStream = (CursorStream)((CursorProvider)resolved).openCursor();
            return IOUtils.toByteArray((InputStream)cursorStream);
        }
        return null;
    }

    public String transformPayload(CustomLoggerConfiguration loggerConfig, StreamingHelper streamingHelper, String payloadString) {
        EncryptionAlgorithm encryptionAlgorithm;
        Objects.requireNonNull(streamingHelper, "StreamingHelper cannot be null");
        if (payloadString == null) {
            return payloadString;
        }
        Compressor compressor = loggerConfig.getCompressor();
        Result<InputStream, Void> executionResult = null;
        if (compressor != null) {
            executionResult = this.compressPayload(loggerConfig, payloadString);
        }
        if ((encryptionAlgorithm = loggerConfig.getEncryptionAlgorithm()) != null) {
            executionResult = this.encryptPayload(loggerConfig, streamingHelper, executionResult, encryptionAlgorithm, payloadString);
        }
        if (executionResult != null) {
            try {
                payloadString = Base64.encodeBytes((byte[])this.convertToByteArray(executionResult.getOutput(), streamingHelper));
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while transforming payload", e);
            }
        }
        return payloadString;
    }

    public Result<InputStream, Void> compressPayload(CustomLoggerConfiguration loggerConfig, String payload) {
        Object executeCompress = null;
        GzipCompressorStrategy compressorStrategy = new GzipCompressorStrategy();
        DefaultOperationParametersBuilder parametersBuilder = DefaultOperationParameters.builder().addParameter("content", (Object)new ByteArrayInputStream(payload.getBytes())).addParameter("compressor", (Object)compressorStrategy);
        try {
            return loggerConfig.getExtensionsClient().execute("Compression", "compress", (OperationParameters)parametersBuilder.build());
        }
        catch (Exception e) {
            throw new RuntimeException("Compression Exception", e);
        }
    }

    public Result<InputStream, Void> encryptPayload(CustomLoggerConfiguration loggerConfig, StreamingHelper streamingHelper, Result<InputStream, Void> executeCompress, EncryptionAlgorithm encryptionAlgorithm, String payload) {
        JceEncryptionPbeAlgorithm jceEncryptionPbeAlgorithm = JceEncryptionPbeAlgorithm.valueOf((String)encryptionAlgorithm.toString());
        ByteArrayInputStream content = executeCompress != null ? new ByteArrayInputStream(this.convertToByteArray(executeCompress.getOutput(), streamingHelper)) : new ByteArrayInputStream(payload.getBytes());
        DefaultOperationParametersBuilder encryptionParametersBuilder = DefaultOperationParameters.builder().addParameter("content", (Object)content).addParameter("algorithm", (Object)jceEncryptionPbeAlgorithm).addParameter("password", (Object)loggerConfig.getEncryptionPassword());
        try {
            return loggerConfig.getExtensionsClient().execute("Crypto", "jceEncryptPbe", (OperationParameters)encryptionParametersBuilder.build());
        }
        catch (Exception e) {
            throw new RuntimeException("Encryption Error", e);
        }
    }
}

