/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.email.util.internal;

import com.avioconsulting.mule.email.util.api.processor.AttachmentAttribute;
import com.avioconsulting.mule.email.util.api.processor.AttachmentAttributes;
import com.avioconsulting.mule.email.util.api.processor.EmailProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.codec.binary.Base64;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

public class MuleEmailUtilModuleOperations {
    private static String HTML_MSG_CONTENT_TYPE = "text/html";
    private static String TEXT_MSG_CONTENT_TYPE = "text/plain";

    @DisplayName(value="Generate Email Content")
    @MediaType(value="*/*", strict=false)
    public String generateEmailContent(@ParameterGroup(name="Email Info") EmailProperties emailProperties, @ParameterGroup(name="Attachment Info") AttachmentAttributes attachmentAttributes) {
        String encodedEmail = "";
        try {
            byte[] emailContent = this.createEmailContent(emailProperties, attachmentAttributes);
            encodedEmail = this.encodeString(emailContent);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return encodedEmail;
    }

    private byte[] createEmailContent(EmailProperties emailProperties, AttachmentAttributes attachmentAttributes) throws MessagingException, IOException {
        String[] toAddressList;
        String fromAddress = emailProperties.getFrom();
        String toAddress = emailProperties.getTo();
        String ccAddress = emailProperties.getCc();
        String bccAddress = emailProperties.getBcc();
        String messageSubject = emailProperties.getSubject();
        String messageContentType = emailProperties.getContentType();
        String messageContent = emailProperties.getContent();
        List<AttachmentAttribute> attachmentList = attachmentAttributes.getAttributeList();
        Properties props = new Properties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage emailMessage = new MimeMessage(session);
        emailMessage.setFrom((Address)new InternetAddress(fromAddress));
        for (String toEmailAddress : toAddressList = toAddress.split("[,]", 0)) {
            emailMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toEmailAddress));
        }
        if (ccAddress != null && ccAddress != "") {
            String[] ccAddressList;
            for (String ccEmailAddress : ccAddressList = ccAddress.split("[,]", 0)) {
                emailMessage.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(ccEmailAddress));
            }
        }
        if (bccAddress != null && bccAddress != "") {
            String[] bccAddressList;
            for (String bccEmailAddress : bccAddressList = bccAddress.split("[,]", 0)) {
                emailMessage.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bccEmailAddress));
            }
        }
        emailMessage.setSubject(messageSubject);
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        if (attachmentList != null && attachmentList.size() > 0) {
            for (AttachmentAttribute attachment : attachmentList) {
                mimeBodyPart = new MimeBodyPart();
                byte[] attachmentContent = this.decodeString(attachment.getContent());
                ByteArrayDataSource source = new ByteArrayDataSource(attachmentContent, attachment.getContentType());
                mimeBodyPart.setDataHandler(new DataHandler((DataSource)source));
                mimeBodyPart.setFileName(attachment.getFilename());
                multipart.addBodyPart((BodyPart)mimeBodyPart);
                emailMessage.setContent((Multipart)multipart);
            }
        }
        if (messageContentType != null && messageContentType.equalsIgnoreCase(HTML_MSG_CONTENT_TYPE)) {
            mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent((Object)messageContent, "text/html; charset=utf-8");
            multipart.addBodyPart((BodyPart)mimeBodyPart);
            emailMessage.setContent((Multipart)multipart);
        } else {
            emailMessage.setText(messageContent);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        emailMessage.writeTo((OutputStream)buffer);
        byte[] rawMessageBytes = buffer.toByteArray();
        return rawMessageBytes;
    }

    private byte[] decodeString(String base64Message) {
        byte[] decodedContent = Base64.decodeBase64((String)base64Message);
        return decodedContent;
    }

    private String encodeString(byte[] rawMessageBytes) {
        String encodedContent = Base64.encodeBase64URLSafeString((byte[])rawMessageBytes);
        return encodedContent;
    }
}

