/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.utils;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Date;

public class GoogleJWTAuth {
    public static String createJWT(String privateKeyId, String privateKey, String issuer, String user, String scopes, String audience) {
        String result = "";
        try {
            long nowMs = System.currentTimeMillis();
            KeyFactory kf = KeyFactory.getInstance("RSA");
            byte[] byteKey = Base64.getDecoder().decode(privateKey);
            PKCS8EncodedKeySpec PK8privateKey = new PKCS8EncodedKeySpec(byteKey);
            RSAPrivateKey priv = (RSAPrivateKey)kf.generatePrivate(PK8privateKey);
            String signedJwt = user != null || !user.equals("") ? Jwts.builder().setHeaderParam("alg", (Object)"RS256").setHeaderParam("typ", (Object)"JWT").setHeaderParam("kid", (Object)privateKeyId).setIssuer(issuer).setSubject(user).setAudience(audience).setExpiration(new Date(nowMs + 3600000L)).setIssuedAt(new Date(nowMs)).claim("scope", (Object)scopes).signWith(SignatureAlgorithm.RS256, (Key)priv).compact() : Jwts.builder().setHeaderParam("alg", (Object)"RS256").setHeaderParam("typ", (Object)"JWT").setHeaderParam("kid", (Object)privateKeyId).setIssuer(issuer).setAudience(audience).setExpiration(new Date(nowMs + 3600000L)).setIssuedAt(new Date(nowMs)).claim("scope", (Object)scopes).signWith(SignatureAlgorithm.RS256, (Key)priv).compact();
            result = signedJwt;
        }
        catch (Exception e) {
            result = "ERROR: " + e.getMessage();
        }
        return result;
    }
}

