/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.health;

import com.avioconsulting.mule.health.GarbageCollectionStats;
import com.avioconsulting.mule.health.IndividualGCStats;
import com.avioconsulting.mule.health.JvmStats;
import com.avioconsulting.mule.health.MemoryStats;
import com.avioconsulting.mule.health.OSStats;
import com.avioconsulting.mule.health.ThreadStats;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;

public class JvmInfo {
    public static JvmStats getJvmStats() throws Exception {
        try {
            MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
            ThreadMXBean threadBead = ManagementFactory.getThreadMXBean();
            List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
            JvmStats stats = new JvmStats();
            MemoryStats memStats = new MemoryStats();
            MemoryUsage heap = memoryBean.getHeapMemoryUsage();
            memStats.setHeapMemoryUsageInit(heap.getInit());
            memStats.setHeapMemoryUsageUsed(heap.getUsed());
            memStats.setHeapMemoryUsageCommitted(heap.getCommitted());
            memStats.setHeapMemoryUsageMax(heap.getMax());
            MemoryUsage nonHeap = memoryBean.getNonHeapMemoryUsage();
            memStats.setNonHeapMemoryUsageInit(nonHeap.getInit());
            memStats.setNonHeapMemoryUsageUsed(nonHeap.getUsed());
            memStats.setNonHeapMemoryUsageCommitted(nonHeap.getCommitted());
            memStats.setNonHeapMemoryUsageMax(nonHeap.getMax());
            ThreadStats threadStats = new ThreadStats();
            threadStats.setActiveThreadCount(threadBead.getThreadCount());
            threadStats.setDaemonThreadCount(threadBead.getDaemonThreadCount());
            ArrayList<IndividualGCStats> gcStatsCollection = new ArrayList<IndividualGCStats>();
            for (GarbageCollectorMXBean gcBean : gcBeans) {
                IndividualGCStats individualGcStats = new IndividualGCStats();
                individualGcStats.setGcName(gcBean.getName());
                individualGcStats.setCollectionCount(gcBean.getCollectionCount());
                individualGcStats.setCollectionTime(gcBean.getCollectionTime());
                gcStatsCollection.add(individualGcStats);
            }
            GarbageCollectionStats gcStats = new GarbageCollectionStats();
            gcStats.setGarbageCollection(gcStatsCollection);
            stats.setMemoryStats(memStats);
            stats.setThreadStats(threadStats);
            stats.setGarbageCollectionStats(gcStats);
            return stats;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static OSStats getOsStats() {
        OSStats stats = new OSStats();
        OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        stats.setPid(ManagementFactory.getRuntimeMXBean().getName());
        stats.setSystemLoadAverage(osBean.getSystemLoadAverage());
        stats.setAvailableProcessors(osBean.getAvailableProcessors());
        stats.setFreePhysicalMemorySize(osBean.getFreePhysicalMemorySize());
        stats.setProcessCpuTime(osBean.getProcessCpuTime());
        stats.setSystemCpuLoad(osBean.getSystemCpuLoad());
        stats.setProcessCpuLoad(osBean.getProcessCpuLoad());
        return stats;
    }
}

