/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.maven.formatter;

import com.avioconsulting.mule.linter.model.rule.RuleExecutor;
import com.avioconsulting.mule.maven.formatter.FormatOptionsEnum;
import com.avioconsulting.mule.maven.formatter.IFormatter;
import com.avioconsulting.mule.maven.formatter.impl.AbstractFormatter;
import com.avioconsulting.mule.maven.formatter.impl.ConsoleFormatter;
import com.avioconsulting.mule.maven.formatter.impl.JsonFormatter;
import com.avioconsulting.mule.maven.mojo.AbstractMuleLinterMojo;

public class FormatterBuilder {
    private FormatterBuilder() {
    }

    public static IFormatter build(FormatOptionsEnum format, AbstractMuleLinterMojo mojo, RuleExecutor re) {
        AbstractFormatter formatter;
        switch (format) {
            case CONSOLE: {
                formatter = new ConsoleFormatter();
                break;
            }
            case JSON: {
                formatter = new JsonFormatter();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Formatter not supported for %s", format.getValue()));
            }
        }
        return formatter.withRuleExecutor(re).withMojo(mojo);
    }
}

