/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.maven.formatter.impl;

import com.avioconsulting.mule.linter.model.rule.Rule;
import com.avioconsulting.mule.linter.model.rule.RuleSeverity;
import com.avioconsulting.mule.maven.formatter.impl.AbstractFormatter;
import java.util.List;
import org.apache.maven.plugin.logging.Log;

public class ConsoleFormatter
extends AbstractFormatter {
    @Override
    public void buildReport() {
        Log log = this.mojo.getLog();
        Integer rulesCount = this.ruleExecutor.getRuleCount();
        String separator = "****************************************************************************";
        log.info((CharSequence)separator);
        log.info((CharSequence)"AVIO Mule linter execution results");
        log.info((CharSequence)String.format("%s rules executed.", rulesCount));
        log.info((CharSequence)"Rule validation results");
        List violationList = this.ruleExecutor.getResults();
        violationList.forEach(violation -> {
            Rule rule = violation.getRule();
            String ruleSeverity = rule.getSeverity().toString();
            String ruleId = rule.getRuleId();
            String ruleName = rule.getRuleName();
            StringBuilder messageLogBuilder = new StringBuilder();
            messageLogBuilder.append(String.format(" - [%s] %s - %s : ", ruleSeverity, ruleId, ruleName));
            String lineNumber = "";
            if (violation.getLineNumber() > 0) {
                lineNumber = violation.getLineNumber().toString();
            }
            messageLogBuilder.append(String.format("File:Linenumber: %s:%s ", violation.getFileName(), lineNumber));
            messageLogBuilder.append(violation.getMessage());
            if (rule.getSeverity().equals((Object)RuleSeverity.MINOR)) {
                log.info((CharSequence)messageLogBuilder.toString());
            } else {
                log.warn((CharSequence)messageLogBuilder.toString());
            }
        });
        log.info((CharSequence)String.format("Found a total of %s violations of %s rules.", violationList.size(), rulesCount));
        log.info((CharSequence)separator);
    }
}

