/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.maven.mojo;

import com.avioconsulting.mule.MuleLinter;
import com.avioconsulting.mule.linter.model.ReportFormat;
import com.avioconsulting.mule.linter.model.rule.RuleExecutor;
import com.avioconsulting.mule.maven.formatter.FormatOptionsEnum;
import com.avioconsulting.mule.maven.formatter.FormatterBuilder;
import com.avioconsulting.mule.maven.mojo.AbstractMuleLinterMojo;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="validate", defaultPhase=LifecyclePhase.VALIDATE)
public class MuleLinterValidateMojo
extends AbstractMuleLinterMojo {
    @Parameter(property="ruleConfiguration", defaultValue="${basedir}/muleLinter.groovy", readonly=true, required=false)
    private File ruleConfiguration;
    @Parameter(property="appDir", defaultValue="${basedir}", readonly=true, required=false)
    private File appDir;
    @Parameter(property="format", defaultValue="CONSOLE,JSON", readonly=true, required=false)
    private List<FormatOptionsEnum> formats;
    @Parameter(property="failBuild", readonly=true, required=false, defaultValue="false")
    private Boolean failBuild;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MuleLinter muleLinter = new MuleLinter(this.appDir, this.ruleConfiguration, ReportFormat.valueOf((String)FormatOptionsEnum.CONSOLE.name().toUpperCase()));
        this.getLog().debug((CharSequence)String.format("Executing linter config %s against application %s", this.ruleConfiguration.getAbsolutePath(), this.appDir.getAbsolutePath()));
        RuleExecutor ruleExecutor = muleLinter.buildLinterExecutor();
        try {
            for (FormatOptionsEnum format : this.formats) {
                this.getLog().info((CharSequence)String.format("Report formatter found for %s", new Object[]{format}));
                FormatterBuilder.build(format, this, ruleExecutor).buildReport();
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Failed to write report", (Throwable)e);
        }
        this.failIfNeeded(this.failBuild, ruleExecutor.getResults());
    }
}

