/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.interceptor;

import com.avioconsulting.mule.opentelemetry.api.processor.ProcessorComponent;
import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.MuleNotificationProcessor;
import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import io.opentelemetry.api.trace.SpanKind;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.concurrent.ThreadSafe;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ProcessorTracingInterceptor
implements ProcessorInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorTracingInterceptor.class);
    private final MuleNotificationProcessor muleNotificationProcessor;
    private final ConfigurationComponentLocator configurationComponentLocator;

    public ProcessorTracingInterceptor(MuleNotificationProcessor muleNotificationProcessor, ConfigurationComponentLocator configurationComponentLocator) {
        this.muleNotificationProcessor = muleNotificationProcessor;
        this.configurationComponentLocator = configurationComponentLocator;
    }

    public void before(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
        if (this.muleNotificationProcessor.hasConnection()) {
            ProcessorComponent processorComponent = this.muleNotificationProcessor.getProcessorComponent(location.getComponentIdentifier().getIdentifier());
            this.switchTraceContext(event, "OTEL_TRACE_CONTEXT", "OTEL_PREV_TRACE_CONTEXT");
            if (processorComponent == null) {
                String transactionId = this.muleNotificationProcessor.getOpenTelemetryConnection().getTransactionStore().transactionIdFor((Event)event);
                event.addVariable("OTEL_TRACE_CONTEXT", this.muleNotificationProcessor.getOpenTelemetryConnection().getTraceContext(transactionId));
            } else {
                Component component = this.configurationComponentLocator.find(Location.builderFromStringRepresentation((String)location.getLocation()).build()).orElseGet(() -> this.configurationComponentLocator.find(location.getComponentIdentifier().getIdentifier()).stream().filter(c -> c.getLocation().getLocation().equals(location.getLocation())).findFirst().orElse(null));
                if (component == null) {
                    LOGGER.warn("Could not locate a component for {} at {}", (Object)location.getComponentIdentifier().getIdentifier(), (Object)location.getLocation());
                    this.switchTraceContext(event, "OTEL_PREV_TRACE_CONTEXT", "OTEL_TRACE_CONTEXT");
                    return;
                }
                TraceComponent traceComponent = processorComponent.getStartTraceComponent(component, event.getMessage(), event.getCorrelationId());
                if (traceComponent == null) {
                    LOGGER.warn("Could not build a trace component for {} at {}", (Object)location.getComponentIdentifier().getIdentifier(), (Object)location.getLocation());
                    this.switchTraceContext(event, "OTEL_PREV_TRACE_CONTEXT", "OTEL_TRACE_CONTEXT");
                    return;
                }
                LOGGER.trace("Creating Span in the interceptor for {} at {}", (Object)location.getComponentIdentifier().getIdentifier(), (Object)location.getLocation());
                this.muleNotificationProcessor.getOpenTelemetryConnection().addProcessorSpan(traceComponent, location.getRootContainerName());
                String transactionId = this.muleNotificationProcessor.getOpenTelemetryConnection().getTransactionStore().transactionIdFor((Event)event);
                if (ComponentsUtil.isFlowRef(location)) {
                    Optional<ComponentLocation> subFlowLocation = ComponentsUtil.findLocation(traceComponent.getTags().get("mule.app.processor.flowRef.name"), this.configurationComponentLocator).filter(ComponentsUtil::isSubFlow);
                    if (subFlowLocation.isPresent()) {
                        ComponentLocation subFlowComp = subFlowLocation.get();
                        TraceComponent subflowTrace = TraceComponent.named(subFlowComp.getLocation()).withTransactionId(traceComponent.getTransactionId()).withLocation(subFlowComp.getLocation()).withSpanName(subFlowComp.getLocation()).withSpanKind(SpanKind.INTERNAL).withTags(Collections.singletonMap(SemanticAttributes.MULE_APP_SCOPE_SUBFLOW_NAME.getKey(), subFlowComp.getLocation())).withStatsCode(traceComponent.getStatusCode()).withStartTime(traceComponent.getStartTime()).withContext(traceComponent.getContext());
                        this.muleNotificationProcessor.getOpenTelemetryConnection().addProcessorSpan(subflowTrace, traceComponent.getLocation());
                        event.addVariable("OTEL_TRACE_CONTEXT", this.muleNotificationProcessor.getOpenTelemetryConnection().getTraceContext(transactionId, subFlowComp));
                    } else {
                        event.addVariable("OTEL_TRACE_CONTEXT", this.muleNotificationProcessor.getOpenTelemetryConnection().getTraceContext(transactionId, location));
                    }
                } else {
                    event.addVariable("OTEL_TRACE_CONTEXT", this.muleNotificationProcessor.getOpenTelemetryConnection().getTraceContext(transactionId, location));
                }
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Intercepted with logic '{}'", (Object)location);
            }
        }
    }

    public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
        this.switchTraceContext(event, "OTEL_PREV_TRACE_CONTEXT", "OTEL_TRACE_CONTEXT");
    }

    private void switchTraceContext(InterceptionEvent event, String removalContextKey, String newContextKey) {
        if (event.getVariables().containsKey(removalContextKey)) {
            event.addVariable(newContextKey, event.getVariables().get(removalContextKey));
            event.removeVariable(removalContextKey);
        }
    }

    public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
        if (this.muleNotificationProcessor.getConnectionSupplier() != null && LOGGER.isTraceEnabled()) {
            LOGGER.trace("Variables around the interceptor for {} - {}", (Object)location.getLocation(), (Object)event.getVariables().toString());
        }
        return action.proceed();
    }
}

