/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.store;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.store.SpanMeta;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.util.HttpSpanUtil;
import com.avioconsulting.mule.opentelemetry.internal.store.ProcessorSpan;
import com.avioconsulting.mule.opentelemetry.internal.util.PropertiesUtil;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class FlowSpan
implements Serializable {
    private final String flowName;
    private String rootSpanName;
    private final Span span;
    private final String transactionId;
    private final Map<String, ProcessorSpan> childSpans = new ConcurrentHashMap<String, ProcessorSpan>();
    private Map<String, String> tags = new HashMap<String, String>();
    private String apikitConfigName;

    public FlowSpan(String flowName, Span span, String transactionId) {
        this.flowName = flowName;
        this.span = span;
        this.transactionId = transactionId;
    }

    public Span getSpan() {
        return this.span;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public String getApikitConfigName() {
        return this.apikitConfigName;
    }

    public SpanMeta addProcessorSpan(String containerName, TraceComponent traceComponent, SpanBuilder spanBuilder) {
        if (containerName != null) {
            ProcessorSpan ps = new ProcessorSpan(this.getSpan(), traceComponent.getLocation(), this.transactionId, traceComponent.getStartTime(), this.flowName).setTags(this.getTags());
            ProcessorSpan parentSpan = this.childSpans.getOrDefault(containerName, ps);
            spanBuilder.setParent(parentSpan.getContext());
        }
        this.extractAPIKitConfigName(traceComponent);
        this.resetSpanNameIfNeeded(traceComponent);
        Span span = spanBuilder.startSpan();
        ProcessorSpan ps = new ProcessorSpan(span, traceComponent.getLocation(), this.transactionId, traceComponent.getStartTime(), this.flowName).setTags(traceComponent.getTags());
        this.childSpans.put(traceComponent.getLocation(), ps);
        return ps;
    }

    private void resetSpanNameIfNeeded(TraceComponent traceComponent) {
        if (!PropertiesUtil.isUseAPIKitSpanNames()) {
            return;
        }
        if (this.apikitConfigName != null && traceComponent.getName().endsWith(":" + this.apikitConfigName) && this.rootSpanName.endsWith("/*")) {
            String spanName = HttpSpanUtil.apiKitRoutePath(traceComponent.getTags(), this.getRootSpanName());
            this.getSpan().updateName(spanName);
        }
    }

    private void extractAPIKitConfigName(TraceComponent traceComponent) {
        if (this.apikitConfigName == null && "apikit".equals(traceComponent.getTags().get(SemanticAttributes.MULE_APP_PROCESSOR_NAMESPACE.getKey())) && "router".equals(traceComponent.getTags().get(SemanticAttributes.MULE_APP_PROCESSOR_NAME.getKey()))) {
            this.apikitConfigName = traceComponent.getTags().get(SemanticAttributes.MULE_APP_PROCESSOR_CONFIG_REF.getKey());
        }
    }

    public SpanMeta endProcessorSpan(String location, Consumer<Span> spanUpdater, Instant endTime) {
        if (this.childSpans.containsKey(location)) {
            ProcessorSpan removed = this.childSpans.remove(location);
            removed.setEndTime(endTime);
            if (spanUpdater != null) {
                spanUpdater.accept(removed.getSpan());
            }
            removed.getSpan().end(endTime);
            return removed;
        }
        return null;
    }

    public ProcessorSpan findSpan(String location) {
        return this.childSpans.get(location);
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public FlowSpan setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String getRootSpanName() {
        return this.rootSpanName;
    }

    public FlowSpan setRootSpanName(String rootSpanName) {
        this.rootSpanName = rootSpanName;
        return this;
    }
}

