/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.api;

import java.util.Objects;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExpressionManager;

public final class AppIdentifier {
    private final String identifier;
    private final String name;
    private final String orgId;
    private final String envId;

    public AppIdentifier(String name, String orgId, String envId) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(envId);
        this.name = name;
        this.orgId = orgId;
        this.envId = envId;
        this.identifier = envId + "+" + name;
    }

    public String getName() {
        return this.name;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public String getEnvId() {
        return this.envId;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return this.identifier;
    }

    public static AppIdentifier fromEnvironment(ExpressionManager expressionManager) {
        String envId;
        TypedValue appName = expressionManager.evaluate("#[app.name]", DataType.STRING);
        String orgId = AppIdentifier.getPropertyValue(expressionManager, "csorganization.id", "ORG_ID", "anypoint.platform.client_id");
        if (orgId == null) {
            orgId = "DEFAULT_ORG";
        }
        if ((envId = AppIdentifier.getPropertyValue(expressionManager, "environment.id", "ENV_ID", "anypoint.platform.client_id")) == null) {
            envId = (String)expressionManager.evaluate("#[server.host]", DataType.STRING).getValue();
        }
        return new AppIdentifier((String)appName.getValue(), orgId, envId);
    }

    private static String getPropertyValue(ExpressionManager expressionManager, String property, String ... envKeys) {
        String envId = AppIdentifier.getStringValue(expressionManager, property);
        if (envId == null) {
            String envKey;
            String[] stringArray = envKeys;
            int n = stringArray.length;
            for (int i = 0; i < n && (envId = AppIdentifier.getStringValue(expressionManager, envKey = stringArray[i])) == null; ++i) {
            }
        }
        return envId;
    }

    private static String getStringValue(ExpressionManager expressionManager, String property) {
        TypedValue evaluate = expressionManager.evaluate("#[p('" + property + "')]");
        if (evaluate == null || evaluate.getValue() == null) {
            return null;
        }
        return evaluate.getValue().toString();
    }
}

