/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.util;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.LocationPart;

public class ComponentsUtil {
    private static final List<TypedComponentIdentifier.ComponentType> ROUTE_IDENTIFIERS = Arrays.asList(TypedComponentIdentifier.ComponentType.ROUTE, TypedComponentIdentifier.ComponentType.SCOPE);

    public static Optional<ComponentLocation> findLocation(String location, ConfigurationComponentLocator configurationComponentLocator) {
        return configurationComponentLocator.findAllLocations().stream().filter(cl -> cl.getLocation().equals(location)).findFirst();
    }

    public static boolean isSubFlow(ComponentLocation location) {
        return location.getComponentIdentifier().getIdentifier().getName().equals("sub-flow");
    }

    public static boolean isFlowRef(ComponentLocation location) {
        return location.getComponentIdentifier().getIdentifier().getName().equals("flow-ref");
    }

    public static Optional<Component> findComponent(ComponentIdentifier identifier, String location, ConfigurationComponentLocator configurationComponentLocator) {
        return configurationComponentLocator.find(identifier).stream().filter(c -> c.getLocation().getLocation().equals(location)).findFirst();
    }

    public static String getRouteContainerLocation(TraceComponent traceComponent) {
        List parts;
        String parentLocation = null;
        if (traceComponent.getComponentLocation() != null && (parts = traceComponent.getComponentLocation().getParts()).size() > 2) {
            int routeIndex = parts.size() - 3;
            LocationPart parentPart = (LocationPart)parts.get(routeIndex);
            parentLocation = parentPart.getPartIdentifier().filter(ComponentsUtil::isRoute).map(tci -> {
                StringBuffer sb = new StringBuffer(((LocationPart)parts.get(0)).getPartPath());
                for (int i = 1; i <= routeIndex; ++i) {
                    sb.append("/").append(((LocationPart)parts.get(i)).getPartPath());
                }
                return sb.toString();
            }).orElse(null);
        }
        return parentLocation;
    }

    public static String getLocationParent(String location) {
        String locationParent = location;
        if (locationParent.contains("/")) {
            locationParent = location.substring(0, location.lastIndexOf("/"));
        }
        if (locationParent.contains("/")) {
            locationParent = locationParent.substring(0, locationParent.lastIndexOf("/"));
        }
        return locationParent;
    }

    public static boolean isRoute(TypedComponentIdentifier tci) {
        Objects.requireNonNull(tci, "Component Identifier cannot be null");
        return tci.getIdentifier().getName().equals("route");
    }

    public static boolean isFlowTrace(TraceComponent traceComponent) {
        return traceComponent != null && traceComponent.getTags() != null && "flow".equalsIgnoreCase(traceComponent.getTags().get(SemanticAttributes.MULE_APP_PROCESSOR_NAME.getKey()));
    }

    public static boolean isFirstProcessor(ComponentLocation location) {
        String interceptPath = String.format("%s/processors/0", location.getRootContainerName());
        return ComponentsUtil.isFlowTypeContainer(location) && interceptPath.equalsIgnoreCase(location.getLocation());
    }

    public static boolean isFlowTypeContainer(ComponentLocation componentLocation) {
        return !componentLocation.getParts().isEmpty() && ((LocationPart)componentLocation.getParts().get(0)).getPartIdentifier().filter(c -> TypedComponentIdentifier.ComponentType.FLOW.equals((Object)c.getType()) || TypedComponentIdentifier.ComponentType.SCOPE.equals((Object)c.getType())).isPresent();
    }
}

