/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.connection.TraceContextHandler;
import com.avioconsulting.mule.opentelemetry.internal.processor.AbstractProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.ComponentWrapper;
import com.avioconsulting.mule.opentelemetry.internal.processor.util.HttpSpanUtil;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.semconv.SemanticAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProcessorComponent
extends AbstractProcessorComponent {
    static final String NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/http";
    public static final String NAMESPACE = "http";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpProcessorComponent.class);

    @Override
    protected String getNamespace() {
        return NAMESPACE;
    }

    @Override
    protected List<String> getOperations() {
        return Collections.singletonList("request");
    }

    @Override
    protected List<String> getSources() {
        return Collections.singletonList("listener");
    }

    @Override
    protected SpanKind getSpanKind() {
        return SpanKind.CLIENT;
    }

    private boolean isRequester(ComponentIdentifier componentIdentifier) {
        return this.namespaceSupported(componentIdentifier) && this.operationSupported(componentIdentifier);
    }

    private boolean isHttpListener(ComponentIdentifier componentIdentifier) {
        return this.namespaceSupported(componentIdentifier) && this.sourceSupported(componentIdentifier);
    }

    private boolean isListenerFlowEvent(EnrichedServerNotification notification) {
        return "flow".equals(notification.getComponent().getIdentifier().getName()) && this.isHttpListener(this.getSourceIdentifier(notification));
    }

    @Override
    public TraceComponent getEndTraceComponent(EnrichedServerNotification notification) {
        TraceComponent endTraceComponent = super.getEndTraceComponent(notification);
        Message responseMessage = notification.getEvent().getError().map(Error::getErrorMessage).orElse(notification.getEvent().getMessage());
        TypedValue responseAttributes = responseMessage.getAttributes();
        notification.getEvent().getError().ifPresent(error -> endTraceComponent.withStatsCode(this.getSpanStatus(false, 500)));
        if (responseAttributes.getValue() == null || !(responseAttributes.getValue() instanceof HttpResponseAttributes)) {
            return endTraceComponent;
        }
        HttpResponseAttributes attributes = (HttpResponseAttributes)responseAttributes.getValue();
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(SemanticAttributes.HTTP_STATUS_CODE.getKey(), Integer.toString(attributes.getStatusCode()));
        endTraceComponent.withStatsCode(this.getSpanStatus(false, attributes.getStatusCode()));
        tags.put(SemanticAttributes.HTTP_RESPONSE_CONTENT_LENGTH.getKey(), (String)attributes.getHeaders().get((Object)"content-length"));
        if (endTraceComponent.getTags() != null) {
            tags.putAll(endTraceComponent.getTags());
        }
        return endTraceComponent.withTags(tags);
    }

    private StatusCode getSpanStatus(boolean isServer, int statusCode) {
        int maxStatus = isServer ? 500 : 400;
        StatusCode result = statusCode >= 100 && statusCode < maxStatus ? StatusCode.UNSET : StatusCode.ERROR;
        return result;
    }

    @Override
    public TraceComponent getStartTraceComponent(Component component, Event event) {
        TraceComponent traceComponent = super.getStartTraceComponent(component, event);
        Map<String, String> requesterTags = this.getAttributes(component, event.getMessage().getAttributes());
        requesterTags.putAll(traceComponent.getTags());
        return TraceComponent.of(component.getLocation().getRootContainerName(), component.getLocation()).withTags(requesterTags).withSpanName(requesterTags.get(SemanticAttributes.HTTP_ROUTE.getKey())).withTransactionId(traceComponent.getTransactionId()).withSpanKind(this.getSpanKind()).withEventContextId(traceComponent.getEventContextId());
    }

    @Override
    protected <A> Map<String, String> getAttributes(Component component, TypedValue<A> attributes) {
        ComponentWrapper componentWrapper = new ComponentWrapper(component, this.configurationComponentLocator);
        HashMap<String, String> tags = new HashMap<String, String>();
        if (this.isRequester(component.getIdentifier())) {
            tags.putAll(this.getRequesterTags(componentWrapper));
        } else {
            HttpRequestAttributes attr = (HttpRequestAttributes)attributes.getValue();
            tags.putAll(this.attributesToTags(attr));
        }
        return tags;
    }

    private Map<String, String> getRequesterTags(ComponentWrapper componentWrapper) {
        Map<String, String> configParameters;
        HashMap<String, String> tags = new HashMap<String, String>();
        String path = componentWrapper.getParameters().get("path");
        Map<String, String> connectionParameters = componentWrapper.getConfigConnectionParameters();
        if (!connectionParameters.isEmpty()) {
            tags.put(SemanticAttributes.HTTP_SCHEME.getKey(), connectionParameters.getOrDefault("protocol", "").toLowerCase());
            tags.put(SemanticAttributes.HTTP_HOST.getKey(), connectionParameters.getOrDefault("host", "").concat(":").concat(connectionParameters.getOrDefault("port", "")));
            tags.put(SemanticAttributes.NET_PEER_NAME.getKey(), connectionParameters.getOrDefault("host", ""));
            tags.put(SemanticAttributes.NET_PEER_PORT.getKey(), connectionParameters.getOrDefault("port", ""));
        }
        if (!(configParameters = componentWrapper.getConfigParameters()).isEmpty() && configParameters.containsKey("basePath") && !configParameters.get("basePath").equalsIgnoreCase("/")) {
            path = configParameters.get("basePath").concat(path);
        }
        tags.put(SemanticAttributes.HTTP_ROUTE.getKey(), path);
        tags.put(SemanticAttributes.HTTP_METHOD.getKey(), componentWrapper.getParameters().get("method"));
        return tags;
    }

    @Override
    public TraceComponent getSourceStartTraceComponent(EnrichedServerNotification notification, TraceContextHandler traceContextHandler) {
        if (!this.isListenerFlowEvent(notification)) {
            return null;
        }
        TypedValue attributesTypedValue = notification.getEvent().getMessage().getAttributes();
        HttpRequestAttributes attributes = (HttpRequestAttributes)attributesTypedValue.getValue();
        Map<String, String> tags = this.attributesToTags(attributes);
        return TraceComponent.of(notification.getResourceIdentifier(), notification.getComponent().getLocation()).withTags(tags).withTransactionId(this.getTransactionId(notification)).withSpanName(HttpSpanUtil.spanName(tags, attributes.getListenerPath())).withContext(traceContextHandler.getTraceContext(attributes.getHeaders(), AbstractProcessorComponent.ContextMapGetter.INSTANCE));
    }

    @Override
    public TraceComponent getSourceEndTraceComponent(EnrichedServerNotification notification, TraceContextHandler traceContextHandler) {
        try {
            TypedValue httpStatus = (TypedValue)notification.getEvent().getVariables().get("httpStatus");
            if (httpStatus != null) {
                String statusCode = null;
                statusCode = httpStatus.getDataType().getMediaType().withoutParameters().equals((Object)MediaType.APPLICATION_JSON) ? IOUtils.toString((CursorStreamProvider)((CursorStreamProvider)StreamingUtils.consumeRepeatableValue((TypedValue)httpStatus).getValue())) : TypedValue.unwrap((Object)httpStatus).toString();
                TraceComponent traceComponent = this.getTraceComponentBuilderFor(notification);
                traceComponent.withTags(Collections.singletonMap(SemanticAttributes.HTTP_STATUS_CODE.getKey(), statusCode));
                traceComponent.withStatsCode(this.getSpanStatus(true, Integer.parseInt(statusCode)));
                return traceComponent;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to extract httpStatus variable value. Resulted span may not have http status code attribute.");
        }
        return null;
    }

    private Map<String, String> attributesToTags(HttpRequestAttributes attributes) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(SemanticAttributes.HTTP_HOST.getKey(), (String)attributes.getHeaders().get((Object)"host"));
        tags.put(SemanticAttributes.HTTP_USER_AGENT.getKey(), (String)attributes.getHeaders().get((Object)"user-agent"));
        tags.put(SemanticAttributes.HTTP_METHOD.getKey(), attributes.getMethod());
        tags.put(SemanticAttributes.HTTP_SCHEME.getKey(), attributes.getScheme());
        tags.put(SemanticAttributes.HTTP_ROUTE.getKey(), attributes.getListenerPath());
        tags.put(SemanticAttributes.HTTP_TARGET.getKey(), attributes.getRequestPath());
        tags.put(SemanticAttributes.HTTP_FLAVOR.getKey(), attributes.getVersion().substring(attributes.getVersion().lastIndexOf("/") + 1));
        return tags;
    }
}

