/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.notifications.listeners;

import com.avioconsulting.mule.opentelemetry.internal.processor.MuleNotificationProcessor;
import com.avioconsulting.mule.opentelemetry.internal.util.BatchHelperUtil;
import java.util.Collections;
import java.util.Map;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractMuleNotificationListener<T extends Notification>
implements NotificationListener<T> {
    protected final MuleNotificationProcessor muleNotificationProcessor;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMuleNotificationListener.class);

    public AbstractMuleNotificationListener(MuleNotificationProcessor muleNotificationProcessor) {
        this.muleNotificationProcessor = muleNotificationProcessor;
    }

    public void onNotification(T notification) {
        LOGGER.trace("===> Received {}:{}", (Object)notification.getClass().getName(), (Object)notification.getAction().getIdentifier());
        if (BatchHelperUtil.shouldSkipThisBatchProcessing(this.getEvent(notification))) {
            LOGGER.trace("Batch support is disabled. Batch spans will not be processed for location - {}", notification);
            return;
        }
        this.replaceMDCEntry(this.getEvent(notification));
        this.processNotification(notification);
    }

    protected abstract Event getEvent(T var1);

    protected abstract void processNotification(T var1);

    private void replaceMDCEntry(Event event) {
        if (event == null) {
            return;
        }
        this.replaceMDCEntry(event.getVariables());
    }

    protected void replaceMDCEntry(Map<String, TypedValue<?>> variables) {
        TypedValue contextMap = variables.getOrDefault("OTEL_TRACE_CONTEXT", TypedValue.of(Collections.emptyMap()));
        Map context = (Map)contextMap.getValue();
        if (context == null || context.isEmpty()) {
            return;
        }
        this.replaceMDCEntry(context, "traceId");
        this.replaceMDCEntry(context, "traceIdLongLowPart");
        this.replaceMDCEntry(context, "spanId");
        this.replaceMDCEntry(context, "spanIdLong");
    }

    private void replaceMDCEntry(Map<String, String> contextMap, String key) {
        if (contextMap.containsKey(key)) {
            MDC.remove((String)key);
            MDC.put((String)key, (String)contextMap.get(key));
        }
    }
}

