/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.notifications.listeners;

import com.avioconsulting.mule.opentelemetry.api.ee.batch.notifications.OtelBatchNotification;
import com.avioconsulting.mule.opentelemetry.internal.notifications.listeners.AbstractMuleNotificationListener;
import com.avioconsulting.mule.opentelemetry.internal.processor.MuleNotificationProcessor;
import java.util.Collections;
import org.mule.runtime.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtelBatchNotificationListener
extends AbstractMuleNotificationListener<OtelBatchNotification> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OtelBatchNotificationListener.class);

    public OtelBatchNotificationListener(MuleNotificationProcessor muleNotificationProcessor) {
        super(muleNotificationProcessor);
    }

    @Override
    protected Event getEvent(OtelBatchNotification notification) {
        return null;
    }

    @Override
    protected void processNotification(OtelBatchNotification notification) {
        this.replaceMDCEntry(notification.getRecord() != null ? notification.getRecord().getAllVariables() : Collections.emptyMap());
        LOGGER.debug("Batch notification received: {}, Step: {}, Record: {}", new Object[]{notification.getActionName(), notification.getStep() == null ? "null" : notification.getStep().getName(), notification.getRecord() == null ? "null" : notification.getRecord().getCurrentStepId()});
        int action = Integer.parseInt(notification.getAction().getIdentifier());
        if (OtelBatchNotification.STEP_JOB_END == action) {
            this.muleNotificationProcessor.handleBatchStepEndEvent(notification);
        } else if (OtelBatchNotification.STEP_RECORD_END == action || OtelBatchNotification.STEP_RECORD_FAILED == action) {
            this.muleNotificationProcessor.handleBatchStepRecordEndEvent(notification);
        } else if (OtelBatchNotification.ON_COMPLETE_END == action || OtelBatchNotification.ON_COMPLETE_FAILED == action) {
            this.muleNotificationProcessor.handleBatchOnCompleteEndEvent(notification);
        } else if (OtelBatchNotification.JOB_SUCCESSFUL == action || OtelBatchNotification.JOB_STOPPED == action) {
            this.muleNotificationProcessor.handleBatchEndEvent(notification);
        }
    }
}

