/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import com.avioconsulting.mule.opentelemetry.api.ee.batch.BatchJob;
import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.AbstractProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.ComponentWrapper;
import com.avioconsulting.mule.opentelemetry.internal.util.BatchHelperUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.OpenTelemetryUtil;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchProcessorComponent
extends AbstractProcessorComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchProcessorComponent.class);

    @Override
    public boolean canHandle(ComponentIdentifier componentIdentifier) {
        return this.namespaceSupported(componentIdentifier) && this.operationSupported(componentIdentifier);
    }

    @Override
    protected String getNamespace() {
        return "batch";
    }

    @Override
    protected List<String> getSources() {
        return Collections.emptyList();
    }

    @Override
    protected List<String> getOperations() {
        return Collections.singletonList("job");
    }

    @Override
    public TraceComponent getStartTraceComponent(Component component, Event event) {
        TraceComponent startTraceComponent = super.getStartTraceComponent(component, event);
        String jobName = this.addJobTags(startTraceComponent, component);
        return TraceComponent.of("batch:job", startTraceComponent.getComponentLocation()).withSpanName("batch:job").withTags(startTraceComponent.getTags()).withTransactionId(startTraceComponent.getTransactionId()).withEventContextId(startTraceComponent.getEventContextId()).withSpanKind(this.getSpanKind()).withContext(startTraceComponent.getContext());
    }

    private String addJobTags(TraceComponent traceComponent, Component component) {
        try {
            BatchJob batchJob = BatchHelperUtil.toBatchJob(component);
            if (batchJob != null) {
                String steps = batchJob.getSteps().stream().map(step -> {
                    String stepName = step.getName();
                    String location = step.getComponent().getLocation().getLocation();
                    return stepName + "|" + location;
                }).collect(Collectors.joining(","));
                traceComponent.getTags().put(SemanticAttributes.MULE_BATCH_JOB_STEPS.getKey(), steps);
            }
        }
        catch (Exception batchJob) {
            // empty catch block
        }
        ComponentWrapper wrapper = new ComponentWrapper(component, this.configurationComponentLocator);
        String jobName = wrapper.getParameter("jobName");
        traceComponent.getTags().put(SemanticAttributes.MULE_BATCH_JOB_NAME.getKey(), jobName);
        return jobName;
    }

    @Override
    public TraceComponent getEndTraceComponent(EnrichedServerNotification notification) {
        TraceComponent endTraceComponent = super.getEndTraceComponent(notification);
        String transactionId = OpenTelemetryUtil.getEventTransactionId(notification.getEvent().getContext().getId());
        endTraceComponent.withTransactionId(transactionId);
        TypedValue batchJobInstanceId = null;
        batchJobInstanceId = (TypedValue)notification.getEvent().getVariables().get("batchJobInstanceId");
        if (batchJobInstanceId != null && batchJobInstanceId.getValue() != null) {
            endTraceComponent.getTags().put(SemanticAttributes.MULE_BATCH_JOB_INSTANCE_ID.getKey(), batchJobInstanceId.getValue().toString());
        }
        this.addJobTags(endTraceComponent, notification.getComponent());
        return TraceComponent.of("batch:job", endTraceComponent.getComponentLocation()).withTransactionId(endTraceComponent.getTransactionId()).withTags(endTraceComponent.getTags()).withStatsCode(endTraceComponent.getStatusCode()).withContext(endTraceComponent.getContext()).withSpanKind(this.getSpanKind()).withErrorMessage(endTraceComponent.getErrorMessage());
    }
}

