/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.store;

import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.store.Transaction;
import io.opentelemetry.api.trace.Span;
import java.time.Instant;
import java.util.function.Consumer;

public abstract class AbstractTransaction
implements Transaction {
    private final String transactionId;
    private final String rootSpanName;
    private final String traceId;
    private final Instant startTime;
    private Instant endTime;

    public AbstractTransaction(String transactionId, String traceId, String rootSpanName, Instant startTime) {
        this.transactionId = transactionId;
        this.rootSpanName = rootSpanName;
        this.traceId = traceId;
        this.startTime = startTime;
    }

    @Override
    public String getTransactionId() {
        return this.transactionId;
    }

    @Override
    @Deprecated
    public String getRootFlowName() {
        return this.rootSpanName;
    }

    @Override
    public String getRootSpanName() {
        return this.rootSpanName;
    }

    @Override
    public String getTraceId() {
        return this.traceId;
    }

    @Override
    public Instant getStartTime() {
        return this.startTime;
    }

    @Override
    public Instant getEndTime() {
        return this.endTime;
    }

    private void setEndTime(Instant endTime) {
        this.endTime = endTime;
    }

    @Override
    public void endRootSpan(TraceComponent traceComponent, Consumer<Span> endSpan) {
        endSpan.accept(this.getTransactionSpan());
        this.setEndTime(traceComponent.getEndTime());
    }
}

