/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.store;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.store.SpanMeta;
import com.avioconsulting.mule.opentelemetry.api.store.TransactionMeta;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.store.AbstractTransaction;
import com.avioconsulting.mule.opentelemetry.internal.store.ContainerSpan;
import com.avioconsulting.mule.opentelemetry.internal.store.ProcessorSpan;
import com.avioconsulting.mule.opentelemetry.internal.util.BatchHelperUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchTransaction
extends AbstractTransaction {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchTransaction.class);
    private final ConcurrentHashMap<String, AtomicReference<ContainerSpan>> stepSpans = new ConcurrentHashMap();
    private final Map<String, ProcessorSpan> stepProcessorSpans = new ConcurrentHashMap<String, ProcessorSpan>();
    private final Span rootSpan;
    private final Function<String, SpanBuilder> spanBuilderFunction;
    private final ConfigurationComponentLocator componentLocator;
    private boolean rootSpanEnded = false;
    private final TraceComponent batchTraceComponent;
    private final Map<String, String> stepLocationNames = new HashMap<String, String>();
    private Context rootContext;

    public BatchTransaction(String jobInstanceId, String traceId, String batchJobName, Span rootSpan, TraceComponent batchTraceComponent, Function<String, SpanBuilder> spanBuilderFunction, ConfigurationComponentLocator componentLocator) {
        super(jobInstanceId, traceId, batchJobName, batchTraceComponent.getStartTime());
        this.batchTraceComponent = batchTraceComponent;
        this.rootSpan = rootSpan;
        this.rootContext = rootSpan.storeInContext(Context.current());
        this.spanBuilderFunction = spanBuilderFunction;
        this.componentLocator = componentLocator;
        this.extractStepLocations(batchTraceComponent);
    }

    private void extractStepLocations(TraceComponent batchTraceComponent) {
        String jobSteps = batchTraceComponent.getTags().get(SemanticAttributes.MULE_BATCH_JOB_STEPS.getKey());
        if (jobSteps != null) {
            StringTokenizer tokenizer = new StringTokenizer(jobSteps, ",");
            while (tokenizer.hasMoreTokens()) {
                String step = tokenizer.nextToken().trim();
                if (step.isEmpty()) continue;
                String stepName = step.substring(0, step.indexOf("|"));
                String stepLocation = step.substring(step.indexOf("|") + 1);
                this.stepLocationNames.put(stepLocation, stepName);
            }
        }
    }

    private ContainerSpan addOrGetContainerSpan(String location, String stepName, TraceComponent processorTrace) {
        AtomicReference containerSpanRef = this.stepSpans.computeIfAbsent(location, s -> new AtomicReference());
        String name = "batch:step";
        String spanName = stepName;
        if (ComponentsUtil.isBatchOnComplete(location, this.componentLocator)) {
            name = "batch:on-complete";
            spanName = "batch:on-complete";
        } else {
            name = "batch:step:" + stepName;
        }
        ContainerSpan ContainerSpan2 = (ContainerSpan)containerSpanRef.get();
        if (ContainerSpan2 == null) {
            SpanBuilder spanBuilder;
            ContainerSpan newContainerSpan;
            TraceComponent stepTraceComponent = TraceComponent.of(name).withSpanName(spanName).withTags(new HashMap<String, String>()).withTransactionId(processorTrace.getTransactionId()).withSpanKind(SpanKind.INTERNAL).withLocation(location).withEventContextId(processorTrace.getEventContextId()).withStartTime(processorTrace.getStartTime());
            processorTrace.getTags().forEach((k, v) -> {
                if (!k.startsWith("mule.app.processor")) {
                    stepTraceComponent.getTags().put((String)k, (String)v);
                }
            });
            if (stepName != null) {
                stepTraceComponent.getTags().put(SemanticAttributes.MULE_BATCH_JOB_STEP_NAME.getKey(), stepName);
            }
            if (containerSpanRef.compareAndSet(null, newContainerSpan = new ContainerSpan(location, (spanBuilder = this.spanBuilderFunction.apply(name).setParent(this.rootContext)).startSpan(), stepTraceComponent))) {
                this.stepProcessorSpans.putIfAbsent(stepTraceComponent.getSpanName(), newContainerSpan.getRootProcessorSpan());
                ContainerSpan2 = newContainerSpan;
            }
        }
        return ContainerSpan2;
    }

    @Override
    public SpanMeta addProcessorSpan(String containerPath, TraceComponent traceComponent, SpanBuilder spanBuilder) {
        SpanMeta spanMeta = null;
        String stepName = traceComponent.getTags().get(SemanticAttributes.MULE_BATCH_JOB_STEP_NAME.getKey());
        if (ComponentsUtil.isBatchOnComplete(containerPath, this.componentLocator)) {
            stepName = "batch:on-complete";
        }
        ProcessorSpan containerProcessorSpan = this.getStepProcessorSpan(traceComponent, stepName);
        ContainerSpan ContainerSpan2 = null;
        if (containerProcessorSpan == null) {
            ContainerSpan2 = this.addOrGetContainerSpan(containerPath, this.stepLocationNames.get(containerPath), traceComponent);
            containerProcessorSpan = this.getStepProcessorSpan(traceComponent, stepName);
        } else {
            ContainerSpan2 = this.stepSpans.get(containerProcessorSpan.getLocation()).get();
        }
        if (containerProcessorSpan.getLocation().equalsIgnoreCase(containerPath)) {
            spanMeta = this.processContainerChild(containerPath, traceComponent, spanBuilder, ContainerSpan2, containerProcessorSpan);
        } else {
            SpanMeta aggrSpan = this.addAggregatorSpanIfNeeded(containerPath, traceComponent, ContainerSpan2, containerProcessorSpan);
            if (aggrSpan != null) {
                traceComponent.withContext(aggrSpan.getContext());
            }
            spanMeta = ContainerSpan2.addProcessorSpan(containerPath, traceComponent, spanBuilder);
        }
        return spanMeta;
    }

    private SpanMeta addAggregatorSpanIfNeeded(String containerPath, TraceComponent traceComponent, ContainerSpan ContainerSpan2, ProcessorSpan containerProcessorSpan) {
        SpanMeta aggrSpan = null;
        TraceComponent aggrTraceComponent = null;
        if (containerPath.endsWith("/aggregator") && null == ContainerSpan2.findSpan(traceComponent.contextScopedPath(containerPath))) {
            SpanBuilder aggrSpanBuilder = this.spanBuilderFunction.apply("batch:aggregator").setParent(containerProcessorSpan.getContext()).setSpanKind(SpanKind.INTERNAL).setStartTimestamp(traceComponent.getStartTime());
            aggrTraceComponent = TraceComponent.of("batch:aggregator").withLocation(containerPath).withSpanName("batch:aggregator").withTags(new HashMap<String, String>()).withContext(containerProcessorSpan.getContext()).withTransactionId(traceComponent.getTransactionId()).withSpanKind(SpanKind.INTERNAL).withStartTime(traceComponent.getStartTime()).withEventContextId(traceComponent.getEventContextId()).withSiblings(traceComponent.getSiblings());
            BatchHelperUtil.copyBatchTags(traceComponent, aggrTraceComponent);
            aggrTraceComponent.getTags().put(SemanticAttributes.MULE_APP_PROCESSOR_NAMESPACE.getKey(), "batch");
            aggrTraceComponent.getTags().put(SemanticAttributes.MULE_APP_PROCESSOR_NAME.getKey(), "aggregator");
            aggrSpan = ContainerSpan2.addProcessorSpan(containerPath.substring(0, containerPath.lastIndexOf("/")), aggrTraceComponent, aggrSpanBuilder);
        }
        return aggrSpan;
    }

    private SpanMeta processContainerChild(String containerPath, TraceComponent traceComponent, SpanBuilder spanBuilder, ContainerSpan stepSpan, ProcessorSpan processorSpan) {
        SpanMeta spanMeta;
        if (ComponentsUtil.isBatchOnComplete(containerPath, this.componentLocator)) {
            spanMeta = stepSpan.addProcessorSpan(containerPath, traceComponent, spanBuilder);
        } else {
            String recordPath = containerPath + "/record";
            if (traceComponent.getLocation().equalsIgnoreCase(containerPath + "/processors/0")) {
                TraceComponent recordTrace = TraceComponent.of("batch:step-record").withLocation(recordPath).withTransactionId(traceComponent.getTransactionId()).withStartTime(traceComponent.getStartTime()).withSpanName("batch:step-record").withTags(traceComponent.getTags()).withEventContextId(traceComponent.getEventContextId());
                SpanBuilder record = this.spanBuilderFunction.apply(recordTrace.getName());
                SpanMeta recordSpanMeta = stepSpan.addChildContainer(recordTrace, record.setParent(processorSpan.getContext()));
                spanMeta = stepSpan.addProcessorSpan(recordTrace.getLocation(), traceComponent, spanBuilder.setParent(recordSpanMeta.getContext()));
            } else {
                spanMeta = stepSpan.addProcessorSpan(recordPath, traceComponent, spanBuilder);
            }
        }
        return spanMeta;
    }

    private ProcessorSpan getStepProcessorSpan(TraceComponent traceComponent, String containerName) {
        if (containerName == null) {
            return null;
        }
        ProcessorSpan processorSpan = this.stepProcessorSpans.get(containerName);
        return processorSpan == null ? null : processorSpan.setTags(traceComponent.getTags());
    }

    private ProcessorSpan getStepProcessorSpan(TraceComponent traceComponent) {
        String containerName = traceComponent.getTags().get(SemanticAttributes.MULE_BATCH_JOB_STEP_NAME.getKey());
        return this.getStepProcessorSpan(traceComponent, containerName);
    }

    @Override
    public SpanMeta endProcessorSpan(TraceComponent traceComponent, Consumer<Span> spanUpdater, Instant endTime) {
        String locationParent;
        if ("batch:step".equalsIgnoreCase(traceComponent.getName()) || "batch:on-complete".equalsIgnoreCase(traceComponent.getName())) {
            return this.endContainerSpan(traceComponent, this.stepProcessorSpans.get(traceComponent.getSpanName()));
        }
        String spanName = traceComponent.getTags().get(SemanticAttributes.MULE_BATCH_JOB_STEP_NAME.getKey());
        if (spanName == null && ComponentsUtil.isBatchOnComplete(locationParent = ComponentsUtil.getLocationParent(traceComponent.getLocation()), this.componentLocator)) {
            spanName = "batch:on-complete";
        }
        if (spanName != null) {
            ProcessorSpan aggrSpan;
            String stepLocation = this.stepProcessorSpans.get(spanName).getLocation();
            ContainerSpan ContainerSpan2 = this.stepSpans.get(stepLocation).get();
            SpanMeta spanMeta = ContainerSpan2.endProcessorSpan(traceComponent, spanUpdater, endTime);
            String aggregatorLocation = stepLocation + "/aggregator";
            if (traceComponent.getLocation() != null && traceComponent.getLocation().startsWith(aggregatorLocation) && (aggrSpan = ContainerSpan2.findSpan(traceComponent.contextScopedPath(aggregatorLocation))).getSiblings() == 0L) {
                TraceComponent aggrTraceComponent = TraceComponent.of("batch:aggregator").withLocation(aggregatorLocation).withSpanName("batch:aggregator").withTags(new HashMap<String, String>()).withTransactionId(traceComponent.getTransactionId()).withSpanKind(SpanKind.INTERNAL).withEventContextId(traceComponent.getEventContextId()).withEndTime(traceComponent.getEndTime());
                aggrTraceComponent.getTags().putAll(traceComponent.getTags());
                ContainerSpan2.endProcessorSpan(aggrTraceComponent, spanUpdater, endTime);
            }
            return spanMeta;
        }
        return null;
    }

    private ProcessorSpan endContainerSpan(TraceComponent traceComponent, ProcessorSpan processorSpan) {
        if (processorSpan == null) {
            return null;
        }
        ContainerSpan stepSpan = this.stepSpans.get(processorSpan.getLocation()).get();
        processorSpan.setEndTime(traceComponent.getEndTime());
        processorSpan.getTags().putAll(traceComponent.getTags());
        stepSpan.getSpan().end(traceComponent.getEndTime());
        return processorSpan;
    }

    @Override
    public Span getTransactionSpan() {
        return this.rootSpan;
    }

    @Override
    public void endRootSpan(TraceComponent traceComponent, Consumer<Span> endSpan) {
        this.stepProcessorSpans.forEach((location, processorSpan) -> this.endContainerSpan(traceComponent, (ProcessorSpan)processorSpan));
        super.endRootSpan(traceComponent, endSpan);
        this.rootSpanEnded = true;
    }

    @Override
    public boolean hasEnded() {
        return this.rootSpanEnded;
    }

    @Override
    public void addChildTransaction(TraceComponent traceComponent, SpanBuilder spanBuilder) {
        ProcessorSpan processorSpan = this.getStepProcessorSpan(traceComponent);
        ContainerSpan stepSpan = this.stepSpans.get(processorSpan.getLocation()).get();
        stepSpan.addChildContainer(traceComponent, spanBuilder);
    }

    @Override
    public TransactionMeta endChildTransaction(TraceComponent traceComponent, Consumer<Span> endSpan) {
        ProcessorSpan processorSpan = this.getStepProcessorSpan(traceComponent);
        ContainerSpan stepSpan = this.stepSpans.get(processorSpan.getLocation()).get();
        return stepSpan.endChildContainer(traceComponent, endSpan);
    }

    @Override
    public ProcessorSpan findSpan(String location) {
        ProcessorSpan processorSpan = null;
        for (Map.Entry<String, AtomicReference<ContainerSpan>> entry : this.stepSpans.entrySet()) {
            processorSpan = entry.getValue().get().findSpan(location);
            if (processorSpan == null) continue;
            return processorSpan;
        }
        return null;
    }

    @Override
    public Span getSpan() {
        return this.rootSpan;
    }

    @Override
    public Map<String, String> getTags() {
        return this.batchTraceComponent.getTags();
    }
}

