/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.store;

import com.avioconsulting.mule.opentelemetry.api.store.SpanMeta;
import com.avioconsulting.mule.opentelemetry.api.traces.ComponentEventContext;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.store.ProcessorSpan;
import com.avioconsulting.mule.opentelemetry.internal.util.OpenTelemetryUtil;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerSpan
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerSpan.class);
    private final String containerName;
    private String rootSpanName;
    private final Span span;
    private final String transactionId;
    private final Map<String, ProcessorSpan> childSpans = new ConcurrentHashMap<String, ProcessorSpan>();
    private Map<String, String> tags = new HashMap<String, String>();
    private final AtomicInteger childContainerCounter = new AtomicInteger();
    private final Context rootContext;
    private final ProcessorSpan rootProcessorSpan;

    public ContainerSpan(String containerName, Span span, TraceComponent traceComponent) {
        this.containerName = containerName;
        this.span = span;
        this.transactionId = traceComponent.getTransactionId();
        this.rootContext = span.storeInContext(Context.current());
        this.setTags(traceComponent.getTags());
        this.setRootSpanName(traceComponent.getSpanName());
        OpenTelemetryUtil.tagsToAttributes(traceComponent, span);
        this.rootProcessorSpan = new ProcessorSpan(span, traceComponent.getLocation(), this.transactionId, traceComponent.getStartTime(), traceComponent.getSpanName());
    }

    public Span getSpan() {
        return this.span;
    }

    public String getContainerName() {
        return this.containerName;
    }

    private Context getRootContext() {
        return this.rootContext;
    }

    public ProcessorSpan getRootProcessorSpan() {
        return this.rootProcessorSpan;
    }

    public SpanMeta addProcessorSpan(String containerName, TraceComponent traceComponent, SpanBuilder spanBuilder) {
        LOGGER.trace("Adding Span at location {} for container {} trace transaction {} context {}", new Object[]{traceComponent.contextScopedLocation(), this.getRootSpanName(), this.transactionId, this.getSpan().getSpanContext().toString()});
        ProcessorSpan parentSpan = null;
        if (containerName != null) {
            if (this.getContainerName().equals(containerName)) {
                spanBuilder.setParent(this.getRootContext());
            } else {
                String contextScopedContainer = traceComponent.contextScopedPath(containerName);
                parentSpan = this.getParentSpan(traceComponent, containerName);
                if (parentSpan == null) {
                    LOGGER.debug("Parent span not found for {}. Child span keys - {}", (Object)contextScopedContainer, this.childSpans.keySet());
                    parentSpan = this.rootProcessorSpan;
                }
                LOGGER.debug("Parent span existence check for {} at {}", (Object)traceComponent.getLocation(), (Object)parentSpan.getLocation());
                spanBuilder.setParent(parentSpan.getContext());
            }
        }
        Span span = spanBuilder.startSpan();
        ProcessorSpan ps = new ProcessorSpan(span, traceComponent.getLocation(), this.transactionId, traceComponent.getStartTime(), this.containerName, traceComponent.getSiblings()).setTags(traceComponent.getTags());
        ps.setParentSpan(parentSpan);
        LOGGER.trace("Adding span for {}:{} - {}", new Object[]{traceComponent.contextScopedLocation(), traceComponent.getSpanName(), span.getSpanContext().getSpanId()});
        this.childSpans.putIfAbsent(traceComponent.contextScopedLocation(), ps);
        return ps;
    }

    public SpanMeta addChildContainer(TraceComponent traceComponent, SpanBuilder spanBuilder) {
        SpanMeta spanMeta = this.addProcessorSpan(null, traceComponent, spanBuilder);
        this.childContainerCounter.incrementAndGet();
        return spanMeta;
    }

    public ProcessorSpan endChildContainer(TraceComponent traceComponent, Consumer<Span> endSpan) {
        ProcessorSpan processorSpan = this.findSpan(traceComponent.contextScopedPath(traceComponent.getName()));
        if (processorSpan == null) {
            LOGGER.trace("Attempting to find in parent scopes for {} in list {}", (Object)traceComponent, this.childSpans);
            processorSpan = this.getParentSpan(traceComponent, traceComponent.getName());
        }
        if (processorSpan != null) {
            endSpan.accept(processorSpan.getSpan());
            processorSpan.setEndTime(traceComponent.getEndTime());
            this.childContainerCounter.decrementAndGet();
            LOGGER.trace("Ended a span of a container {} invoked with flow-ref for transaction {} ", (Object)traceComponent.getName(), (Object)traceComponent.getTransactionId());
        } else {
            LOGGER.trace("No Processor span found for {} ", (Object)traceComponent);
        }
        return processorSpan;
    }

    private ProcessorSpan getParentSpan(ComponentEventContext context, String container) {
        for (int i = 0; i < context.contextNestingLevel(); ++i) {
            ProcessorSpan processorSpan = this.childSpans.get(context.contextCopedPath(container, i));
            if (processorSpan == null) continue;
            return processorSpan;
        }
        return null;
    }

    public SpanMeta endProcessorSpan(TraceComponent traceComponent, Consumer<Span> spanUpdater, Instant endTime) {
        LOGGER.trace("Ending Span at location {} for container {} trace transaction {} context {}", new Object[]{traceComponent.contextScopedLocation(), this.getRootSpanName(), this.transactionId, this.getSpan().getSpanContext().toString()});
        if (this.childSpans.containsKey(traceComponent.contextScopedLocation())) {
            ProcessorSpan removed = Objects.requireNonNull(this.childSpans.remove(traceComponent.contextScopedLocation()), "Missing child span at location " + traceComponent.contextScopedLocation() + " for flow " + this.getRootSpanName() + " trace transaction " + this.transactionId + " context " + this.getSpan().getSpanContext().toString());
            LOGGER.trace("Removing span for {} - {}", (Object)traceComponent.contextScopedLocation(), (Object)removed.getSpanId());
            this.endRouteSpans(traceComponent, endTime);
            removed.setEndTime(endTime);
            if (spanUpdater != null) {
                spanUpdater.accept(removed.getSpan());
            }
            removed.getSpan().end(endTime);
            if (removed.getParentSpan() != null && removed.getParentSpan().getSiblings() > 0L) {
                removed.getParentSpan().decrementActiveSiblingCount();
            }
            return removed;
        }
        return null;
    }

    private void endRouteSpans(TraceComponent traceComponent, Instant endTime) {
        if (traceComponent.getComponentLocation() == null || !TypedComponentIdentifier.ComponentType.ROUTER.equals((Object)traceComponent.getComponentLocation().getComponentIdentifier().getType())) {
            return;
        }
        String regexPattern = String.format("^%s(_\\d.*)?\\/%s\\/route\\/\\d*$", traceComponent.getEventContextId(), Pattern.quote(traceComponent.getLocation()));
        Pattern pattern = Pattern.compile(regexPattern);
        Predicate<String> predicate = pattern.asPredicate();
        this.childSpans.keySet().stream().filter(predicate).forEach(k -> {
            ProcessorSpan removed = this.childSpans.remove(k);
            if (removed != null) {
                LOGGER.trace("Ending Route Span at location {} for container {} trace transaction {} context {}", new Object[]{k, this.getRootSpanName(), this.transactionId, removed.getSpan().getSpanContext()});
                removed.getSpan().end(endTime);
            }
        });
    }

    public ProcessorSpan findSpan(String location) {
        ProcessorSpan processorSpan = this.childSpans.get(location);
        if (processorSpan == null) {
            LOGGER.trace("Could not find span for location {}  in the list {}", (Object)location, this.childSpans);
        }
        return processorSpan;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public ContainerSpan setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String getRootSpanName() {
        return this.rootSpanName;
    }

    public ContainerSpan setRootSpanName(String rootSpanName) {
        this.rootSpanName = rootSpanName;
        return this;
    }

    public boolean childContainersEnded() {
        return this.childContainerCounter.get() <= 0;
    }
}

