/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.store;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.store.SpanMeta;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.util.HttpSpanUtil;
import com.avioconsulting.mule.opentelemetry.internal.store.ContainerSpan;
import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.PropertiesUtil;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.semconv.HttpAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowSpan
extends ContainerSpan {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowSpan.class);
    private String apikitConfigName;

    public FlowSpan(String containerName, Span span, TraceComponent traceComponent) {
        super(containerName, span, traceComponent);
    }

    public String getFlowName() {
        return this.getContainerName();
    }

    public String getApikitConfigName() {
        return this.apikitConfigName;
    }

    @Override
    public SpanMeta addProcessorSpan(String containerName, TraceComponent traceComponent, SpanBuilder spanBuilder) {
        SpanMeta spanMeta = super.addProcessorSpan(containerName, traceComponent, spanBuilder);
        this.extractAPIKitConfigName(traceComponent);
        this.resetSpanNameIfNeeded(traceComponent);
        return spanMeta;
    }

    private void resetSpanNameIfNeeded(TraceComponent traceComponent) {
        if (!PropertiesUtil.isUseAPIKitSpanNames()) {
            return;
        }
        if (this.apikitConfigName != null && ComponentsUtil.isFlowTrace(traceComponent) && traceComponent.getName().endsWith(":" + this.apikitConfigName) && this.getRootSpanName().endsWith("/*")) {
            String apiKitRoutePath = HttpSpanUtil.apiKitRoutePath(traceComponent.getTags());
            String spanName = this.getRootSpanName().replace("/*", apiKitRoutePath);
            this.setRootSpanName(spanName);
            this.getSpan().updateName(spanName);
            String httpRoute = spanName.substring(spanName.lastIndexOf(" ") + 1);
            this.getTags().put(HttpAttributes.HTTP_ROUTE.getKey(), httpRoute);
            this.getSpan().setAttribute(HttpAttributes.HTTP_ROUTE, (Object)httpRoute);
        }
    }

    private void extractAPIKitConfigName(TraceComponent traceComponent) {
        if (this.apikitConfigName == null && "apikit".equals(traceComponent.getTags().get(SemanticAttributes.MULE_APP_PROCESSOR_NAMESPACE.getKey())) && "router".equals(traceComponent.getTags().get(SemanticAttributes.MULE_APP_PROCESSOR_NAME.getKey()))) {
            this.apikitConfigName = traceComponent.getTags().get(SemanticAttributes.MULE_APP_PROCESSOR_CONFIG_REF.getKey());
        }
    }

    public boolean childFlowsEnded() {
        return this.childContainersEnded();
    }
}

