/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.store;

import com.avioconsulting.mule.opentelemetry.api.store.SpanMeta;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class ProcessorSpan
implements SpanMeta {
    private final Span span;
    private final String location;
    private final String transactionId;
    private final Instant startTime;
    private Instant endTime;
    private final String flowName;
    private Context context;
    private Map<String, String> tags = new HashMap<String, String>();
    private ProcessorSpan parentSpan;
    private final AtomicLong siblingCount = new AtomicLong();

    public ProcessorSpan(Span span, String location, String transactionId, Instant startTime, String flowName) {
        this(span, location, transactionId, startTime, flowName, -1L);
    }

    public ProcessorSpan(Span span, String location, String transactionId, Instant startTime, String flowName, long siblings) {
        this.span = span;
        this.location = location;
        this.transactionId = transactionId;
        this.startTime = startTime;
        this.flowName = flowName;
        this.siblingCount.set(siblings);
    }

    @Override
    public String getTransactionId() {
        return this.transactionId;
    }

    @Override
    public String getRootFlowName() {
        return this.flowName;
    }

    @Override
    public String getRootSpanName() {
        return this.flowName;
    }

    public long getSiblings() {
        return this.siblingCount.longValue();
    }

    public void decrementActiveSiblingCount() {
        this.siblingCount.decrementAndGet();
    }

    @Override
    public String getTraceId() {
        return this.span.getSpanContext().getTraceId();
    }

    @Override
    public String getSpanId() {
        return this.span.getSpanContext().getSpanId();
    }

    @Override
    public Context getContext() {
        if (this.context == null) {
            this.context = this.span.storeInContext(Context.current());
        }
        return this.context;
    }

    @Override
    public Span getSpan() {
        return this.span;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public Instant getStartTime() {
        return this.startTime;
    }

    @Override
    public Instant getEndTime() {
        return this.endTime;
    }

    public ProcessorSpan setEndTime(Instant endTime) {
        this.endTime = endTime;
        return this;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    public ProcessorSpan setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ProcessorSpan getParentSpan() {
        return this.parentSpan;
    }

    public ProcessorSpan setParentSpan(ProcessorSpan parentSpan) {
        this.parentSpan = parentSpan;
        return this;
    }

    public String toString() {
        return "ProcessorSpan{span=" + this.span + ", location='" + this.location + '\'' + ", transactionId='" + this.transactionId + '\'' + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", flowName='" + this.flowName + '\'' + ", context=" + this.context + ", tags=" + this.tags + '}';
    }
}

