/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.util;

import com.avioconsulting.mule.opentelemetry.api.ee.batch.BatchJob;
import com.avioconsulting.mule.opentelemetry.api.ee.batch.BatchStep;
import com.avioconsulting.mule.opentelemetry.api.ee.batch.BatchUtil;
import com.avioconsulting.mule.opentelemetry.api.ee.batch.Record;
import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.OpenTelemetryUtil;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.metadata.TypedValue;

public class BatchHelperUtil {
    private static BatchUtil batchUtilDelegate;
    private static boolean batchSupportDisabled;

    public static void _resetForTesting() {
        batchSupportDisabled = true;
        batchUtilDelegate = null;
    }

    public static void init(BatchUtil batchUtil) {
        batchUtilDelegate = batchUtil;
    }

    private static BatchUtil getBatchUtil() {
        return batchUtilDelegate;
    }

    public static BatchStep toBatchStep(Component component) {
        return BatchHelperUtil.isBatchSupportDisabled() ? null : BatchHelperUtil.getBatchUtil().toBatchStep(component);
    }

    public static BatchJob toBatchJob(Component component) {
        return BatchHelperUtil.isBatchSupportDisabled() ? null : BatchHelperUtil.getBatchUtil().toBatchJob(component);
    }

    public static boolean isBatchStep(String location, ConfigurationComponentLocator componentLocator) {
        Optional component = componentLocator.find(Location.builderFromStringRepresentation((String)location).build());
        return component.filter(arg_0 -> ((BatchUtil)batchUtilDelegate).isBatchStep(arg_0)).isPresent();
    }

    public static boolean notBatchChildContainer(String containerName, ConfigurationComponentLocator componentLocator) {
        return BatchHelperUtil.isBatchStep(containerName, componentLocator) || ComponentsUtil.isBatchOnComplete(containerName, componentLocator);
    }

    public static boolean hasBatchJobInstanceId(TraceComponent traceComponent) {
        return traceComponent.getTags().containsKey(SemanticAttributes.MULE_BATCH_JOB_INSTANCE_ID.getKey());
    }

    public static String getBatchJobInstanceId(TraceComponent traceComponent) {
        return traceComponent.getTags().get(SemanticAttributes.MULE_BATCH_JOB_INSTANCE_ID.getKey());
    }

    public static String getBatchJobInstanceId(Event event) {
        TypedValue batchJobInstanceId = null;
        batchJobInstanceId = (TypedValue)event.getVariables().get("batchJobInstanceId");
        if (batchJobInstanceId != null && batchJobInstanceId.getValue() != null) {
            return batchJobInstanceId.getValue().toString();
        }
        return null;
    }

    public static boolean isBatchStepFirstProcessor(ComponentLocation location, Event event, ConfigurationComponentLocator componentLocator) {
        if (BatchHelperUtil.isBatchSupportDisabled()) {
            return false;
        }
        return BatchHelperUtil.getBatchJobInstanceId(event) != null && BatchHelperUtil.isBatchStep(ComponentsUtil.getLocationParent(location.getLocation()), componentLocator) && ComponentsUtil.isFirstProcessorInScope(location);
    }

    public static boolean hasBatchStep(TraceComponent traceComponent) {
        return traceComponent.getTags().containsKey(SemanticAttributes.MULE_BATCH_JOB_STEP_NAME.getKey());
    }

    public static void addBatchTags(TraceComponent traceComponent, Event event) {
        String batchJobId = BatchHelperUtil.getBatchJobInstanceId(event);
        if (!BatchHelperUtil.isBatchSupportDisabled() && batchJobId != null) {
            List records;
            traceComponent.getTags().put(SemanticAttributes.MULE_BATCH_JOB_INSTANCE_ID.getKey(), batchJobId);
            if (event.getVariables().containsKey("_mule_batch_INTERNAL_record") && event.getVariables().get("_mule_batch_INTERNAL_record") != null && ((TypedValue)event.getVariables().get("_mule_batch_INTERNAL_record")).getValue() != null) {
                Record record = BatchHelperUtil.getBatchUtil().toRecord(((TypedValue)event.getVariables().get("_mule_batch_INTERNAL_record")).getValue());
                traceComponent.getTags().put(SemanticAttributes.MULE_BATCH_JOB_STEP_NAME.getKey(), record.getCurrentStepId());
            } else if (event.getVariables().containsKey("records") && event.getVariables().get("records") != null && ((TypedValue)event.getVariables().get("records")).getValue() != null && !(records = (List)((TypedValue)event.getVariables().get("records")).getValue()).isEmpty()) {
                Record record = BatchHelperUtil.getBatchUtil().toRecord(records.get(0));
                traceComponent.getTags().put(SemanticAttributes.MULE_BATCH_JOB_STEP_NAME.getKey(), record.getCurrentStepId());
                traceComponent.getTags().put(SemanticAttributes.MULE_BATCH_JOB_STEP_AGGREGATOR_RECORD_COUNT.getKey(), String.valueOf(records.size()));
            }
        }
    }

    public static void copyBatchTags(TraceComponent source, TraceComponent target) {
        source.getTags().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("mule.batch.job")).forEach(e -> target.getTags().put((String)e.getKey(), (String)e.getValue()));
    }

    public static void enableBatchSupport() {
        batchSupportDisabled = false;
    }

    public static boolean isBatchSupportDisabled() {
        return batchSupportDisabled;
    }

    public static boolean shouldSkipThisBatchProcessing(Event event) {
        return event != null && BatchHelperUtil.isBatchSupportDisabled() && OpenTelemetryUtil.getEventTransactionId(event).equalsIgnoreCase(BatchHelperUtil.getBatchJobInstanceId(event));
    }

    static {
        batchSupportDisabled = true;
    }
}

