/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.util;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.util.BatchHelperUtil;
import io.opentelemetry.api.trace.SpanKind;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.core.api.el.ExpressionManager;

public class ComponentsUtil {
    public static final String BATCH_AGGREGATOR = "batch:aggregator";
    private static final List<TypedComponentIdentifier.ComponentType> ROUTE_IDENTIFIERS = Arrays.asList(TypedComponentIdentifier.ComponentType.ROUTE, TypedComponentIdentifier.ComponentType.SCOPE);
    public static final String BATCH_STEP_TAG = "batch:step";
    public static final String BATCH_STEP_RECORD_TAG = "batch:step-record";
    public static final String BATCH_JOB_TAG = "batch:job";
    public static final String BATCH_ON_COMPLETE_TAG = "batch:on-complete";

    public static Optional<ComponentLocation> findLocation(String location, ConfigurationComponentLocator configurationComponentLocator) {
        return configurationComponentLocator.findAllLocations().stream().filter(cl -> cl.getLocation().equals(location)).findFirst();
    }

    public static boolean isSubFlow(ComponentLocation location) {
        return location.getComponentIdentifier().getIdentifier().getName().equals("sub-flow");
    }

    public static boolean isFlowRef(ComponentLocation location) {
        return location.getComponentIdentifier().getIdentifier().getName().equals("flow-ref");
    }

    public static Optional<Component> findComponent(ComponentIdentifier identifier, String location, ConfigurationComponentLocator configurationComponentLocator) {
        return configurationComponentLocator.find(identifier).stream().filter(c -> c.getLocation().getLocation().equals(location)).findFirst();
    }

    public static String getRouteContainerLocation(TraceComponent traceComponent) {
        List parts;
        String parentLocation = null;
        if (traceComponent.getComponentLocation() != null && (parts = traceComponent.getComponentLocation().getParts()).size() > 2) {
            int routeIndex = parts.size() - 3;
            LocationPart parentPart = (LocationPart)parts.get(routeIndex);
            parentLocation = parentPart.getPartIdentifier().filter(ComponentsUtil::isRoute).map(tci -> {
                StringBuffer sb = new StringBuffer(((LocationPart)parts.get(0)).getPartPath());
                for (int i = 1; i <= routeIndex; ++i) {
                    sb.append("/").append(((LocationPart)parts.get(i)).getPartPath());
                }
                return sb.toString();
            }).orElse(null);
        }
        return parentLocation;
    }

    public static String getLocationParent(String location) {
        String locationParent = location;
        if (locationParent.contains("/")) {
            locationParent = location.substring(0, location.lastIndexOf("/"));
        }
        if (locationParent.contains("/")) {
            locationParent = locationParent.substring(0, locationParent.lastIndexOf("/"));
        }
        return locationParent;
    }

    public static boolean isRoute(TypedComponentIdentifier tci) {
        Objects.requireNonNull(tci, "Component Identifier cannot be null");
        return tci.getIdentifier().getName().equals("route") || TypedComponentIdentifier.ComponentType.ROUTE.equals((Object)tci.getType());
    }

    public static boolean isFlowTrace(TraceComponent traceComponent) {
        return traceComponent != null && traceComponent.getTags() != null && "flow".equalsIgnoreCase(traceComponent.getTags().get(SemanticAttributes.MULE_APP_PROCESSOR_NAME.getKey()));
    }

    public static boolean isFirstProcessor(ComponentLocation location) {
        String interceptPath = String.format("%s/processors/0", location.getRootContainerName());
        return ComponentsUtil.isFlowTypeContainer(location) && interceptPath.equalsIgnoreCase(location.getLocation());
    }

    public static boolean isFirstProcessorInScope(ComponentLocation location) {
        if (location.getParts().size() <= 2) {
            return false;
        }
        LocationPart parentPart = (LocationPart)location.getParts().get(location.getParts().size() - 3);
        String firstProcessorPath = String.format("%s/processors/0", ComponentsUtil.getLocationParent(location.getLocation()));
        return parentPart.getPartIdentifier().isPresent() && ComponentsUtil.isRoute((TypedComponentIdentifier)parentPart.getPartIdentifier().get()) && firstProcessorPath.equalsIgnoreCase(location.getLocation());
    }

    public static boolean isFlowTypeContainer(ComponentLocation componentLocation) {
        return !componentLocation.getParts().isEmpty() && ((LocationPart)componentLocation.getParts().get(0)).getPartIdentifier().filter(c -> TypedComponentIdentifier.ComponentType.FLOW.equals((Object)c.getType()) || TypedComponentIdentifier.ComponentType.SCOPE.equals((Object)c.getType())).isPresent();
    }

    public static boolean isAsyncScope(TypedComponentIdentifier identifier) {
        return TypedComponentIdentifier.ComponentType.SCOPE.equals((Object)identifier.getType()) && identifier.getIdentifier().getName().equals("async");
    }

    public static TraceComponent getSubFlowTraceComponent(ComponentLocation subFlowComp, TraceComponent traceComponent) {
        TraceComponent subFlowTrace = TraceComponent.of(subFlowComp).withTransactionId(traceComponent.getTransactionId()).withSpanName(subFlowComp.getLocation()).withSpanKind(SpanKind.INTERNAL).withTags(new HashMap<String, String>()).withStatsCode(traceComponent.getStatusCode()).withStartTime(traceComponent.getStartTime()).withContext(traceComponent.getContext()).withEventContextId(traceComponent.getEventContextId());
        subFlowTrace.getTags().put(SemanticAttributes.MULE_APP_SCOPE_SUBFLOW_NAME.getKey(), subFlowComp.getLocation());
        BatchHelperUtil.copyBatchTags(traceComponent, subFlowTrace);
        return subFlowTrace;
    }

    public static Optional<ComponentLocation> resolveFlowName(ExpressionManager expressionManager, TraceComponent traceComponent, BindingContext context, ConfigurationComponentLocator configurationComponentLocator) {
        String targetFlowName = traceComponent.getTags().get("mule.app.processor.flowRef.name");
        if (expressionManager.isExpression(targetFlowName)) {
            targetFlowName = expressionManager.evaluate(targetFlowName, context).getValue().toString();
            traceComponent.getTags().put("mule.app.processor.flowRef.name", targetFlowName);
        }
        Optional<ComponentLocation> subFlowLocation = ComponentsUtil.findLocation(targetFlowName, configurationComponentLocator).filter(ComponentsUtil::isSubFlow);
        return subFlowLocation;
    }

    public static boolean componentExists(ComponentIdentifier componentIdentifier, String location, ConfigurationComponentLocator componentLocator) {
        return ComponentsUtil.findComponent(componentIdentifier, location, componentLocator).isPresent();
    }

    public static boolean isBatchOnComplete(String location, ConfigurationComponentLocator componentLocator) {
        Optional component = componentLocator.find(Location.builderFromStringRepresentation((String)location).build());
        return component.filter(c -> c.getIdentifier().toString().equalsIgnoreCase(BATCH_ON_COMPLETE_TAG)).isPresent();
    }
}

