/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.util;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class FunctionMemoizer<T, R>
implements Function<T, R> {
    private final Function<T, R> function;
    private final ConcurrentHashMap<T, R> cache = new ConcurrentHashMap();

    public FunctionMemoizer(Function<T, R> function) {
        this.function = Objects.requireNonNull(function);
    }

    @Override
    public R apply(T input) {
        return this.cache.computeIfAbsent(input, this.function);
    }

    public void clear() {
        this.cache.clear();
    }

    public int size() {
        return this.cache.size();
    }

    public static <T, R> FunctionMemoizer<T, R> memoize(Function<T, R> function) {
        return new FunctionMemoizer<T, R>(function);
    }
}

