/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.api.traces;

import com.avioconsulting.mule.opentelemetry.internal.util.StringUtil;
import java.util.Optional;

public interface ComponentEventContext {
    public String getEventContextId();

    public String getLocation();

    public String getEventContextPrimaryId();

    public int contextNestingLevel();

    default public String contextScopedPath(String path) {
        return this.getEventContextId() + "/" + path;
    }

    default public String contextScopedPath(String path, int prevLevel) {
        String eventContextId = this.getEventContextId();
        if (prevLevel <= 0) {
            return ComponentEventContext.contextScopedLocationFor(eventContextId, path);
        }
        int cutPos = eventContextId.length();
        int remaining = prevLevel;
        while (cutPos > 0 && remaining > 0) {
            if (eventContextId.charAt(--cutPos) != '_') continue;
            --remaining;
        }
        return ComponentEventContext.contextScopedLocationFor(eventContextId.substring(0, cutPos), path);
    }

    default public Optional<String> prevContextScopedPath(String path) {
        return Optional.ofNullable(this.getEventContextId().contains(StringUtil.UNDERSCORE) ? this.getEventContextId().substring(0, this.getEventContextId().lastIndexOf(StringUtil.UNDERSCORE)) + "/" + path : null);
    }

    public String contextScopedLocation();

    public static String contextScopedLocationFor(String eventContextId, String location) {
        return eventContextId + "/" + location;
    }
}

