/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.api.traces;

import com.avioconsulting.mule.opentelemetry.api.traces.Clearable;
import com.avioconsulting.mule.opentelemetry.api.traces.ComponentEventContext;
import com.avioconsulting.mule.opentelemetry.api.traces.Taggable;
import com.avioconsulting.mule.opentelemetry.internal.util.StringUtil;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;

public class TraceComponent
implements ComponentEventContext,
AutoCloseable,
Clearable,
Taggable<String, String> {
    private final Map<String, String> tags;
    private String name;
    private String transactionId;
    private String spanName;
    private String location;
    private Context context;
    private SpanKind spanKind;
    private String errorMessage;
    private StatusCode statusCode;
    private Instant startTime = Instant.now();
    private Instant endTime;
    private String eventContextId;
    private ComponentLocation componentLocation;
    private String contextScopedLocation = null;
    private int contextNestingLevel = 0;
    private long siblings = -1L;
    private String eventContextPrimaryId;

    protected TraceComponent(String name, Map<String, String> tags) {
        this.name = name;
        this.tags = tags;
    }

    public static TraceComponent of(String name, Map<String, String> tags) {
        return new TraceComponent(name, tags);
    }

    @Deprecated
    public static TraceComponent of(String name) {
        return new TraceComponent(name, new HashMap<String, String>());
    }

    @Deprecated
    public static TraceComponent of(String name, ComponentLocation location) {
        return TraceComponent.of(name, new HashMap<String, String>()).withLocation(location.getLocation()).withComponentLocation(location);
    }

    @Deprecated
    public static TraceComponent of(Component component) {
        return TraceComponent.of(component.getLocation());
    }

    @Deprecated
    public static TraceComponent of(ComponentLocation location) {
        return TraceComponent.of(location.getLocation(), location);
    }

    public SpanKind getSpanKind() {
        return this.spanKind;
    }

    @Deprecated
    public Map<String, String> getTags() {
        throw new UnsupportedOperationException("Use TraceComponent.getReadOnlyTags() for read-only access to tags instead. For manipulating tags, use individual methods on TraceComponent");
    }

    public Map<String, String> getReadOnlyTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public TraceComponent setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getSpanName() {
        return this.spanName;
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    @Override
    public String getEventContextId() {
        return this.eventContextId;
    }

    public ComponentLocation getComponentLocation() {
        return this.componentLocation;
    }

    public TraceComponent withTags(Map<String, String> val) {
        throw new UnsupportedOperationException("Use TraceComponent.of(String, Map<String,String>) instead");
    }

    public TraceComponent withTransactionId(String val) {
        this.transactionId = val;
        return this;
    }

    public TraceComponent withSpanName(String val) {
        this.spanName = val;
        return this;
    }

    public TraceComponent withLocation(String val) {
        this.location = val;
        if (val == null) {
            this.contextScopedLocation = null;
            return this;
        }
        if (this.getEventContextId() != null && this.contextScopedLocation == null) {
            this.contextScopedLocation = this.getEventContextId() + "/" + val;
        }
        return this;
    }

    public TraceComponent withContext(Context val) {
        this.context = val;
        return this;
    }

    public TraceComponent withSpanKind(SpanKind val) {
        this.spanKind = val;
        return this;
    }

    public TraceComponent withErrorMessage(String val) {
        this.errorMessage = val;
        return this;
    }

    public TraceComponent withStatsCode(StatusCode statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public TraceComponent withStartTime(Instant startTime) {
        this.startTime = startTime;
        return this;
    }

    public TraceComponent withEndTime(Instant endTime) {
        this.endTime = endTime;
        return this;
    }

    public TraceComponent withEventContextId(String eventContextId) {
        this.eventContextId = eventContextId;
        if (eventContextId == null) {
            this.contextScopedLocation = null;
            this.eventContextPrimaryId = null;
            this.contextNestingLevel = 0;
            return this;
        }
        if (this.getLocation() != null && this.contextScopedLocation == null) {
            this.contextScopedLocation = eventContextId + "/" + this.getLocation();
        }
        this.eventContextPrimaryId = eventContextId.contains(StringUtil.UNDERSCORE) ? eventContextId.substring(0, eventContextId.indexOf(StringUtil.UNDERSCORE)) : eventContextId;
        this.contextNestingLevel = StringUtil.countParts(eventContextId, StringUtil.UNDERSCORE_CHAR);
        return this;
    }

    public TraceComponent withComponentLocation(ComponentLocation componentLocation) {
        this.componentLocation = componentLocation;
        return this;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public TraceComponent withSiblings(long siblings) {
        this.siblings = siblings;
        return this;
    }

    public long getSiblings() {
        return this.siblings;
    }

    @Override
    public String contextScopedLocation() {
        return this.contextScopedLocation;
    }

    @Override
    public String getEventContextPrimaryId() {
        return this.eventContextPrimaryId;
    }

    @Override
    public int contextNestingLevel() {
        return this.contextNestingLevel;
    }

    @Override
    public void addTag(String key, String value) {
        if (this.tags != null) {
            this.tags.put(key, value);
        }
    }

    @Override
    public String getTag(String key) {
        if (this.tags != null) {
            return this.tags.get(key);
        }
        return null;
    }

    @Override
    public void addAllTags(Map<String, String> source) {
        if (this.tags != null) {
            this.tags.putAll(source);
        }
    }

    @Override
    public String removeTag(String key) {
        if (this.tags != null) {
            return this.tags.remove(key);
        }
        return null;
    }

    @Override
    public void copyTagsTo(Map<String, String> target) {
        if (this.tags != null && target != null) {
            target.putAll(this.tags);
        }
    }

    @Override
    public void copyTagsTo(Taggable<String, String> target) {
        if (!(target instanceof TraceComponent)) {
            return;
        }
        if (this.tags != null && ((TraceComponent)target).tags != null) {
            ((TraceComponent)target).tags.putAll(this.tags);
        }
    }

    @Override
    public void copyTagsTo(Taggable<String, String> target, Predicate<String> keyFilter) {
        if (!(target instanceof TraceComponent)) {
            return;
        }
        TraceComponent other = (TraceComponent)target;
        if (this.tags != null && other.tags != null) {
            this.tags.forEach((key, value) -> {
                if (keyFilter.test((String)key)) {
                    other.tags.put((String)key, (String)value);
                }
            });
        }
    }

    @Override
    public boolean hasTagFor(String key) {
        return this.tags != null && this.tags.containsKey(key);
    }

    @Override
    public boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    @Override
    public boolean containsTag(String key, String value) {
        return this.tags != null && this.tags.containsKey(key) && this.tags.get(key).equals(value);
    }

    @Override
    public void forEachTagEntry(Consumer<Map.Entry<String, String>> consumer) {
        if (this.tags.isEmpty()) {
            return;
        }
        this.tags.entrySet().forEach(consumer);
    }

    @Override
    public void clear() {
        this.setName(null).withTransactionId(null).withSpanName(null).withLocation(null).withContext(null).withSpanKind(null).withErrorMessage(null).withStatsCode(null).withStartTime(null).withEndTime(null).withEventContextId(null).withComponentLocation(null).withSiblings(-1L);
        if (this.tags != null) {
            this.tags.clear();
        }
    }

    public String toString() {
        return "TraceComponent{tags=" + this.tags + ", name='" + this.name + '\'' + ", transactionId='" + this.transactionId + '\'' + ", spanName='" + this.spanName + '\'' + ", location='" + this.location + '\'' + ", context=" + this.context + ", spanKind=" + this.spanKind + ", errorMessage='" + this.errorMessage + '\'' + ", statusCode=" + this.statusCode + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", eventContextId='" + this.eventContextId + '\'' + ", componentLocation=" + this.componentLocation + '}';
    }

    @Override
    public void close() {
    }
}

