/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.api.traces;

import com.avioconsulting.mule.opentelemetry.internal.store.Transaction;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.context.Context;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TransactionContext {
    private Context context = Context.current();
    private final Map<String, Object> traceContextMap = new HashMap<String, Object>();
    private String spanId = SpanId.getInvalid();
    private String traceId = TraceId.getInvalid();

    public static TransactionContext of(Span span, Transaction transaction) {
        TransactionContext transactionContext = new TransactionContext();
        transactionContext.context = span.storeInContext(Context.current());
        transactionContext.spanId = span.getSpanContext().getSpanId();
        transactionContext.traceId = span.getSpanContext().getTraceId();
        transactionContext.traceContextMap.put("TRACE_TRANSACTION_ID", transaction.getTransactionId());
        transactionContext.traceContextMap.put("traceId", transactionContext.getTraceId());
        transactionContext.traceContextMap.put("spanId", transactionContext.getSpanId());
        return transactionContext;
    }

    public static TransactionContext current() {
        return new TransactionContext();
    }

    public Context getContext() {
        return this.context;
    }

    public Map<String, Object> getTraceContextMap() {
        return new HashMap<String, Object>(this.traceContextMap);
    }

    public String getSpanId() {
        return this.spanId;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionContext that = (TransactionContext)o;
        return Objects.equals(this.getContext(), that.getContext()) && Objects.equals(this.getSpanId(), that.getSpanId()) && Objects.equals(this.getTraceId(), that.getTraceId());
    }

    public int hashCode() {
        return Objects.hash(this.getContext(), this.getSpanId(), this.getTraceId());
    }
}

