/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;

public class TraceContextOutputResolver
implements OutputTypeResolver<String> {
    private static final String RESOLVER_NAME = "TraceContextOutputResolver";
    private static final String CATEGORY_NAME = "TRACE_CONTEXT";
    private static final String TRACE_TRANSACTION_ID = "TRACE_TRANSACTION_ID";
    private static final String TRACE_ID = "traceId";
    private static final String SPAN_ID = "spanId";
    private static final String TRACEPARENT = "traceparent";
    private static final String TRACESTATE = "tracestate";

    public String getResolverName() {
        return RESOLVER_NAME;
    }

    public String getCategoryName() {
        return CATEGORY_NAME;
    }

    public MetadataType getOutputType(MetadataContext context, String key) {
        BaseTypeBuilder typeBuilder = context.getTypeBuilder();
        ObjectTypeBuilder builder = typeBuilder.objectType().id("trace-context").description("Complete trace context with OpenTelemetry and W3C fields");
        this.addTransactionIdField(builder, typeBuilder, true);
        this.addTraceIdHexField(builder, typeBuilder, true);
        this.addSpanIdHexField(builder, typeBuilder, true);
        this.addTraceparentField(builder, typeBuilder, true);
        this.addTracestateField(builder, typeBuilder, false);
        return builder.build();
    }

    private void addTransactionIdField(ObjectTypeBuilder builder, BaseTypeBuilder typeBuilder, boolean required) {
        builder.addField().key(TRACE_TRANSACTION_ID).value((TypeBuilder)typeBuilder.stringType().id("uuid-string")).description("UUID format transaction identifier").required(required);
    }

    private void addTraceIdHexField(ObjectTypeBuilder builder, BaseTypeBuilder typeBuilder, boolean required) {
        builder.addField().key(TRACE_ID).value((TypeBuilder)typeBuilder.stringType().id("trace-id-hex")).description("32-character hexadecimal trace ID").required(required);
    }

    private void addSpanIdHexField(ObjectTypeBuilder builder, BaseTypeBuilder typeBuilder, boolean required) {
        builder.addField().key(SPAN_ID).value((TypeBuilder)typeBuilder.stringType().id("span-id-hex")).description("16-character hexadecimal span ID").required(required);
    }

    private void addTraceparentField(ObjectTypeBuilder builder, BaseTypeBuilder typeBuilder, boolean required) {
        builder.addField().key(TRACEPARENT).value((TypeBuilder)typeBuilder.stringType().id("w3c-traceparent")).description("W3C traceparent: version-traceId-spanId-flags").required(required);
    }

    private void addTracestateField(ObjectTypeBuilder builder, BaseTypeBuilder typeBuilder, boolean required) {
        builder.addField().key(TRACESTATE).value((TypeBuilder)typeBuilder.stringType().id("w3c-tracestate")).description("W3C tracestate header value").required(required);
    }
}

