/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.notifications.listeners;

import com.avioconsulting.mule.opentelemetry.internal.notifications.listeners.AbstractMuleNotificationListener;
import com.avioconsulting.mule.opentelemetry.internal.processor.MuleNotificationProcessor;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.notification.AsyncMessageNotification;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncMessageNotificationListener
extends AbstractMuleNotificationListener<AsyncMessageNotification>
implements org.mule.runtime.api.notification.AsyncMessageNotificationListener<AsyncMessageNotification> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncMessageNotificationListener.class);

    public AsyncMessageNotificationListener(MuleNotificationProcessor muleNotificationProcessor) {
        super(muleNotificationProcessor);
    }

    @Override
    protected Event getEvent(AsyncMessageNotification notification) {
        return notification.getEvent();
    }

    @Override
    protected void processNotification(AsyncMessageNotification notification) {
        switch (Integer.parseInt(notification.getAction().getIdentifier())) {
            case 1901: {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Scheduled {}:{} - {}", new Object[]{notification.getEventName(), notification.getComponent().getIdentifier().getName(), notification.getEvent().getContext().getId()});
                }
                this.muleNotificationProcessor.handleAsyncScheduledEvent(notification);
                break;
            }
            case 1902: {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Completed {} - {}", (Object)notification.getEventName(), (Object)notification.getEvent().getContext().getId());
                }
                this.muleNotificationProcessor.handleProcessorEndEvent((EnrichedServerNotification)notification);
            }
        }
    }
}

