/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.AbstractProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.ComponentWrapper;
import com.avioconsulting.mule.opentelemetry.internal.processor.db.DBConnectionConfigParser;
import com.avioconsulting.mule.opentelemetry.internal.processor.db.DBInfo;
import com.avioconsulting.mule.opentelemetry.internal.processor.db.JDBCUrlParser;
import com.avioconsulting.mule.opentelemetry.internal.util.memoizers.BiFunctionMemoizer;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.semconv.ServerAttributes;
import io.opentelemetry.semconv.incubating.DbIncubatingAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.metadata.TypedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBProcessorComponent
extends AbstractProcessorComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBProcessorComponent.class);
    public static final String NAMESPACE = "db";
    private final BiFunctionMemoizer<String, ComponentWrapper, DBInfo> dbInfoBiFunctionMemoizer = BiFunctionMemoizer.memoize((configName, cw) -> this.getDbInfo((ComponentWrapper)cw));

    @Override
    public boolean canHandle(ComponentIdentifier componentIdentifier) {
        return this.getNamespace().equalsIgnoreCase(componentIdentifier.getNamespace()) && this.getOperations().contains(componentIdentifier.getName().toLowerCase());
    }

    @Override
    protected String getNamespace() {
        return NAMESPACE;
    }

    @Override
    protected List<String> getOperations() {
        return Arrays.asList("select", "update", "insert", "delete", "bulk-update", "bulk-insert", "bulk-delete", "stored-procedure");
    }

    @Override
    protected List<String> getSources() {
        return Collections.emptyList();
    }

    @Override
    protected SpanKind getSpanKind() {
        return SpanKind.CLIENT;
    }

    @Override
    public TraceComponent getStartTraceComponent(Component component, Event event) {
        TraceComponent startTraceComponent;
        block4: {
            startTraceComponent = super.getStartTraceComponent(component, event);
            if (startTraceComponent.hasTagFor("inputParameters")) {
                String inputParametersExpression = startTraceComponent.removeTag("inputParameters");
                try {
                    TypedValue parameters;
                    if (inputParametersExpression != null && this.expressionManager.isExpression(inputParametersExpression) && (parameters = this.expressionManager.evaluate(inputParametersExpression, event.asBindingContext())).getValue() instanceof Map) {
                        Map value = (Map)parameters.getValue();
                        value.forEach((k, v) -> startTraceComponent.addTag(DbIncubatingAttributes.DB_OPERATION_PARAMETER.getAttributeKey(k).getKey(), v == null ? "null" : v.toString()));
                    }
                }
                catch (ExpressionExecutionException e) {
                    if (!LOGGER.isWarnEnabled()) break block4;
                    LOGGER.warn("Failed to evaluate input parameters expression, capturing the SQL operation parameters for {} at {} will be skipped", new Object[]{startTraceComponent.getName(), startTraceComponent.getLocation(), e});
                }
            }
        }
        return startTraceComponent;
    }

    @Override
    protected <A> void addAttributes(Component component, TypedValue<A> attributes, TraceComponent collector) {
        ComponentWrapper componentWrapper = this.componentRegistryService.getComponentWrapper(component);
        DBInfo dbInfo = this.dbInfoBiFunctionMemoizer.apply(componentWrapper.getConfigRef(), componentWrapper);
        collector.addTag(DbIncubatingAttributes.DB_SYSTEM.getKey(), dbInfo.getSystem());
        if (dbInfo.getDatasourceRef() != null) {
            collector.addTag(SemanticAttributes.DB_DATASOURCE.getKey(), dbInfo.getDatasourceRef());
        }
        if (dbInfo.getNamespace() != null) {
            collector.addTag(DbIncubatingAttributes.DB_NAMESPACE.getKey(), dbInfo.getNamespace());
        }
        if (dbInfo.getHost() != null) {
            collector.addTag(ServerAttributes.SERVER_ADDRESS.getKey(), dbInfo.getHost());
        }
        if (dbInfo.getPort() != null) {
            collector.addTag(ServerAttributes.SERVER_PORT.getKey(), dbInfo.getPort());
        }
        collector.addTag(DbIncubatingAttributes.DB_QUERY_TEXT.getKey(), componentWrapper.getParameter("sql"));
        collector.addTag(DbIncubatingAttributes.DB_OPERATION_NAME.getKey(), component.getIdentifier().getName());
        collector.addTag("inputParameters", componentWrapper.getParameter("inputParameters"));
    }

    private DBInfo getDbInfo(ComponentWrapper componentWrapper) {
        Map<String, String> connectionParams = componentWrapper.getConfigConnectionParameters();
        String connectionComponentName = connectionParams.get("component:name");
        String connectionName = "other_sql";
        DBInfo dbInfo = new DBInfo("other_sql", null, null, null, null, null, "", null);
        if (connectionComponentName != null) {
            connectionName = connectionComponentName.substring(0, connectionComponentName.lastIndexOf("-"));
            if ("generic".equalsIgnoreCase(connectionName)) {
                String jdbcUrl = connectionParams.get("url");
                dbInfo = JDBCUrlParser.parse(jdbcUrl);
            } else if ("data-source".equalsIgnoreCase(connectionName)) {
                String dataSourceRef = connectionParams.get("dataSourceRef");
                dbInfo = new DBInfo("other_sql", null, null, null, null, null, dataSourceRef, null);
                if (dataSourceRef != null) {
                    dbInfo.setDatasourceRef(connectionParams.get("dataSourceRef"));
                }
            } else {
                if (connectionName.contains("-")) {
                    connectionName = connectionName.replace("-", "");
                }
                dbInfo = DBConnectionConfigParser.getDBInfo(connectionName, connectionParams);
            }
        }
        return dbInfo;
    }
}

