/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.connection.TraceContextHandler;
import com.avioconsulting.mule.opentelemetry.internal.processor.AbstractProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.ComponentWrapper;
import com.avioconsulting.mule.opentelemetry.internal.processor.util.HttpSpanUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.OpenTelemetryUtil;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import io.opentelemetry.semconv.UserAgentAttributes;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProcessorComponent
extends AbstractProcessorComponent {
    static final String NAMESPACE_URI = "http://www.mulesoft.org/schema/mule/http";
    public static final String NAMESPACE = "http";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpProcessorComponent.class);
    private static final char DOUBLE_QUOTE = '\"';

    @Override
    protected String getNamespace() {
        return NAMESPACE;
    }

    @Override
    protected List<String> getOperations() {
        return Collections.singletonList("request");
    }

    @Override
    protected List<String> getSources() {
        return Collections.singletonList("listener");
    }

    @Override
    protected SpanKind getSpanKind() {
        return SpanKind.CLIENT;
    }

    private boolean isRequester(ComponentIdentifier componentIdentifier) {
        return this.namespaceSupported(componentIdentifier) && this.operationSupported(componentIdentifier);
    }

    private boolean isHttpListener(ComponentIdentifier componentIdentifier) {
        return this.namespaceSupported(componentIdentifier) && this.sourceSupported(componentIdentifier);
    }

    private boolean isListenerFlowEvent(EnrichedServerNotification notification) {
        return "flow".equals(notification.getComponent().getIdentifier().getName()) && this.isHttpListener(this.getSourceIdentifier(notification));
    }

    @Override
    public TraceComponent getEndTraceComponent(EnrichedServerNotification notification) {
        TraceComponent endTraceComponent = super.getEndTraceComponent(notification);
        Message responseMessage = notification.getEvent().getError().map(Error::getErrorMessage).orElse(notification.getEvent().getMessage());
        TypedValue responseAttributes = responseMessage.getAttributes();
        notification.getEvent().getError().ifPresent(error -> endTraceComponent.withStatsCode(this.getSpanStatus(false, 500)));
        if (responseAttributes.getValue() == null || !(responseAttributes.getValue() instanceof HttpResponseAttributes)) {
            return endTraceComponent;
        }
        HttpResponseAttributes attributes = (HttpResponseAttributes)responseAttributes.getValue();
        endTraceComponent.addTag(HttpAttributes.HTTP_RESPONSE_STATUS_CODE.getKey(), Integer.toString(attributes.getStatusCode()));
        endTraceComponent.withStatsCode(this.getSpanStatus(false, attributes.getStatusCode()));
        if (attributes.getHeaders().containsKey((Object)"content-length")) {
            endTraceComponent.addTag(SemanticAttributes.HTTP_RESPONSE_HEADER_CONTENT_LENGTH.getKey(), (String)attributes.getHeaders().get((Object)"content-length"));
        }
        return endTraceComponent;
    }

    private StatusCode getSpanStatus(boolean isServer, int statusCode) {
        int maxStatus = isServer ? 500 : 400;
        StatusCode result = statusCode >= 100 && statusCode < maxStatus ? StatusCode.UNSET : StatusCode.ERROR;
        return result;
    }

    @Override
    public TraceComponent getStartTraceComponent(Component component, Event event) {
        TraceComponent traceComponent = super.getStartTraceComponent(component, event);
        this.addAttributes(component, event.getMessage().getAttributes(), traceComponent);
        return traceComponent.setName(component.getLocation().getRootContainerName()).withLocation(component.getLocation().getLocation()).withSpanName(traceComponent.getTag(HttpAttributes.HTTP_ROUTE.getKey()));
    }

    @Override
    protected <A> void addAttributes(Component component, TypedValue<A> attributes, TraceComponent collector) {
        ComponentWrapper componentWrapper = this.componentRegistryService.getComponentWrapper(component);
        if (this.isRequester(component.getIdentifier())) {
            this.getRequesterTags(componentWrapper, collector);
        } else {
            HttpRequestAttributes attr = (HttpRequestAttributes)attributes.getValue();
            this.attributesToTags(attr, collector);
        }
    }

    private void getRequesterTags(ComponentWrapper componentWrapper, TraceComponent collector) {
        Map<String, String> configParameters;
        String path = componentWrapper.getParameters().get("path");
        Map<String, String> connectionParameters = componentWrapper.getConfigConnectionParameters();
        if (!connectionParameters.isEmpty()) {
            collector.addTag(UrlAttributes.URL_SCHEME.getKey(), connectionParameters.getOrDefault("protocol", "").toLowerCase());
            collector.addTag(ServerAttributes.SERVER_ADDRESS.getKey(), connectionParameters.getOrDefault("host", ""));
            collector.addTag(ServerAttributes.SERVER_PORT.getKey(), connectionParameters.getOrDefault("port", ""));
        }
        if (!(configParameters = componentWrapper.getConfigParameters()).isEmpty() && configParameters.containsKey("basePath") && !configParameters.get("basePath").equalsIgnoreCase("/")) {
            path = configParameters.get("basePath").concat(path).intern();
        }
        collector.addTag(HttpAttributes.HTTP_ROUTE.getKey(), path);
        collector.addTag(HttpAttributes.HTTP_REQUEST_METHOD.getKey(), componentWrapper.getParameters().get("method"));
    }

    @Override
    public TraceComponent getSourceStartTraceComponent(EnrichedServerNotification notification, TraceContextHandler traceContextHandler) {
        TypedValue attributesTypedValue = notification.getEvent().getMessage().getAttributes();
        HttpRequestAttributes attributes = (HttpRequestAttributes)attributesTypedValue.getValue();
        TraceComponent traceComponent = this.traceComponentManager.createTraceComponent(this.getTransactionId(notification), notification.getResourceIdentifier(), notification.getComponent().getLocation()).withContext(traceContextHandler.getTraceContext(attributes.getHeaders(), AbstractProcessorComponent.ContextMapGetter.INSTANCE));
        this.attributesToTags(attributes, traceComponent);
        traceComponent.withSpanName(HttpSpanUtil.spanName(traceComponent, attributes.getListenerPath()));
        return traceComponent;
    }

    @Override
    public TraceComponent getSourceEndTraceComponent(EnrichedServerNotification notification, TraceContextHandler traceContextHandler) {
        block7: {
            try {
                TypedValue httpStatus = (TypedValue)notification.getEvent().getVariables().get("httpStatus");
                if (httpStatus != null) {
                    String statusCode = OpenTelemetryUtil.typedValueToString(httpStatus);
                    if (statusCode.charAt(0) == '\"' && statusCode.charAt(statusCode.length() - 1) == '\"') {
                        if (LOGGER.isWarnEnabled()) {
                            LOGGER.warn("Received HTTP status code as a String '{}', removing the quotes. It is recommended to set the HTTP status to a number.", (Object)statusCode);
                        }
                        statusCode = statusCode.substring(1, statusCode.length() - 1);
                    }
                    TraceComponent traceComponent = this.getTraceComponentBuilderFor(notification);
                    traceComponent.addTag(HttpAttributes.HTTP_RESPONSE_STATUS_CODE.getKey(), statusCode);
                    traceComponent.withStatsCode(this.getSpanStatus(true, Integer.parseInt(statusCode)));
                    return traceComponent;
                }
            }
            catch (NumberFormatException nfe) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Failed to parse httpStatus value to a valid status code - {}", (Object)nfe.getLocalizedMessage());
                }
            }
            catch (Exception ex) {
                if (!LOGGER.isWarnEnabled()) break block7;
                LOGGER.warn("Failed to extract httpStatus variable value. Resulted span may not have http status code attribute. - {}", (Object)ex.getLocalizedMessage());
            }
        }
        return null;
    }

    private void attributesToTags(HttpRequestAttributes attributes, TraceComponent collector) {
        collector.addTag(UserAgentAttributes.USER_AGENT_ORIGINAL.getKey(), (String)attributes.getHeaders().get((Object)"user-agent"));
        collector.addTag(HttpAttributes.HTTP_REQUEST_METHOD.getKey(), attributes.getMethod());
        collector.addTag(UrlAttributes.URL_SCHEME.getKey(), attributes.getScheme());
        collector.addTag(HttpAttributes.HTTP_ROUTE.getKey(), attributes.getListenerPath());
        collector.addTag(UrlAttributes.URL_PATH.getKey(), attributes.getRequestPath());
        if (attributes.getQueryString() != null) {
            collector.addTag(UrlAttributes.URL_QUERY.getKey(), attributes.getQueryString());
        }
    }
}

